/**
 * definitions-editor - BPMN Definitions Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.definitionseditor.error;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.common.IErrorBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.common.IItemDefinitionBean;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.AddElementEvent;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.AfterEditRecordEvent;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.BeforeEditRecordEvent;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.CellClickEvent;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.EditableGridHandler;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.RemoveElementEvent;
import com.ebmwebsourcing.petalsbpm.definitionseditor.common.AbstractController;
import com.ebmwebsourcing.petalsbpm.definitionseditor.definitions.events.AddErrorEvent;
import com.ebmwebsourcing.petalsbpm.definitionseditor.itemdefinition.ItemDefinitionRefComboBox;
import com.gwtext.client.widgets.grid.GridEditor;

public class ErrorController extends AbstractController implements EditableGridHandler{
	
	private List<IItemDefinitionBean> items;
	private ErrorPanel panel;
	private List<IErrorBean> validErrors;
	
	public ErrorController(ErrorPanel panel,List<IItemDefinitionBean> items) {
		
		this.items = items;
		this.panel = panel;
		this.validErrors = new ArrayList<IErrorBean>();
		panel.addHandler(this);
		init();
	}
	
	private void init(){
		
		this.panel.getItemDefRefColumn().setEditor(new GridEditor(new ItemDefinitionRefComboBox(items)));
		
	}

	@Override
	public void onAddElement(AddElementEvent<?> event) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onAfterEditRecord(AfterEditRecordEvent<?> event) {
		
		this.validate(panel.getValues());
		
	}

	private void validate(List<IErrorBean> errors){
		
		for(IErrorBean eb:errors){
			
			if (eb.getName()!=null && eb.getErrorCode()!=null && eb.getStructureRef()!=null){
				
				fireEvent(new AddErrorEvent(eb));
				validErrors.add(eb);
			
			}
			
		}
		
	}
	
	@Override
	public void onBeforeEditorRecord(BeforeEditRecordEvent<?> event) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onRemoveElement(RemoveElementEvent<?> event) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onCellClick(CellClickEvent event) {
		// TODO Auto-generated method stub
		
	}
	
	
	
}
