/**
 * definitions-editor - BPMN Definitions Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.definitionseditor.error;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.common.IErrorBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.common.IItemDefinitionBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.common.ErrorBean;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.AbstractEditableGrid;
import com.ebmwebsourcing.petalsbpm.definitionseditor.Constants.Error;
import com.google.gwt.user.client.DOM;
import com.gwtext.client.data.FieldDef;
import com.gwtext.client.data.ObjectFieldDef;
import com.gwtext.client.data.Record;
import com.gwtext.client.data.StringFieldDef;
import com.gwtext.client.widgets.form.TextField;
import com.gwtext.client.widgets.grid.BaseColumnConfig;
import com.gwtext.client.widgets.grid.ColumnConfig;
import com.gwtext.client.widgets.grid.GridEditor;

public class ErrorPanel extends AbstractEditableGrid<IErrorBean> {

	

	private ColumnConfig itemDefRefColumn;



	public ErrorPanel(List<IErrorBean> data) {
		super(data);
		
	}

	@Override
	protected void buildGrid() {
		super.buildGrid();
		gridPanel.getView().setForceFit(true);
	}
	
	
	@Override
	protected void bind(Record record, IErrorBean value) {
		
		value.setName(record.getAsString(Error.name.toString()));
		value.setErrorCode(record.getAsString(Error.errorCode.toString()));
		value.setStructureRef((IItemDefinitionBean) record.getAsObject(Error.itemRef.toString()));
		
	}

	@Override
	protected String getAddText() {
		return "Add Error";
	}

	@Override
	protected IErrorBean getNewDefaultRecord() {
		return new ErrorBean(DOM.createUniqueId());
	}

	@Override
	protected String getRemoveText() {
		return "Remove Error";
	}

	@Override
	protected Object[] convertDataToObject(IErrorBean data) {
		
		Object[] object = new Object[3];
		
		object[0] = data.getName();
		object[1] = data.getStructureRef();
		object[2] = data.getErrorCode();
		
		return object;
	}

	@Override
	protected List<BaseColumnConfig> getColumnsConfig() {
		
		ArrayList<BaseColumnConfig> cc 		= new ArrayList<BaseColumnConfig>();
		
		ColumnConfig nameColumn = new ColumnConfig(Error.name.getLabel(), Error.name.toString());
		nameColumn.setEditor(new GridEditor(new TextField()));
		
		this.itemDefRefColumn = new ColumnConfig(Error.itemRef.getLabel(), Error.itemRef.toString());
		
		ColumnConfig errorCodeColumn = new ColumnConfig(Error.errorCode.getLabel(), Error.errorCode.toString());
		errorCodeColumn.setEditor(new GridEditor(new TextField()));		
		
		cc.add(nameColumn);
		cc.add(itemDefRefColumn);
		cc.add(errorCodeColumn);
		
		return cc;
	}
	
	public ColumnConfig getItemDefRefColumn() {
		return itemDefRefColumn;
	}
	
	@Override
	protected FieldDef[] getFieldDef() {
		return new FieldDef[]{
				new StringFieldDef(Error.name.toString()),
				new ObjectFieldDef(Error.itemRef.toString()),
				new StringFieldDef(Error.errorCode.toString())
			};
	}


}
