/**
 * definitions-editor - BPMN Definitions Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.definitionseditor.eventdefinition.message;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.common.IMessageBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.event.definition.IMessageEventDefinitionBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.service.IOperationBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.event.definition.MessageEventDefinitionBean;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.AbstractEditableGrid;
import com.ebmwebsourcing.petalsbpm.definitionseditor.Constants.MessageEventDefinition;
import com.google.gwt.user.client.DOM;
import com.gwtext.client.data.FieldDef;
import com.gwtext.client.data.ObjectFieldDef;
import com.gwtext.client.data.Record;
import com.gwtext.client.data.StringFieldDef;
import com.gwtext.client.widgets.grid.BaseColumnConfig;
import com.gwtext.client.widgets.grid.ColumnConfig;
import com.gwtext.client.widgets.grid.EditorGridPanel;

public class MessageEventDefinitionPanel extends AbstractEditableGrid<IMessageEventDefinitionBean>{
	
	
	
	private ColumnConfig msgRefColumn;
	private ColumnConfig operationRefColumn;

	public MessageEventDefinitionPanel(List<IMessageEventDefinitionBean> data) {
		super(data);

	}

	@Override
	protected void bind(Record record, IMessageEventDefinitionBean value) {
		value.setMessage((IMessageBean) record.getAsObject(MessageEventDefinition.messageRef.toString()));
		value.setOperation((IOperationBean) record.getAsObject(MessageEventDefinition.operation.toString()));
	}
	
	@Override
	protected void buildGrid() {
		super.buildGrid();
		gridPanel.getView().setForceFit(true);
	}
	
	@Override
	protected String getAddText() {
		return "Add Message Event Definition";
	}

	@Override
	protected IMessageEventDefinitionBean getNewDefaultRecord() {
		return new MessageEventDefinitionBean(DOM.createUniqueId());
	}

	@Override
	protected String getRemoveText() {
		return "Remove Message Event Definition";
	}

	@Override
	protected Object[] convertDataToObject(IMessageEventDefinitionBean data) {
		
		Object[] object = new Object[3];
		
		object[0] = data.getId();
		object[1] = data.getMessage();
		object[2] = data.getOperation();
		
		return object;
	}

	@Override
	protected List<BaseColumnConfig> getColumnsConfig() {
		
		ArrayList<BaseColumnConfig> cc 		= new ArrayList<BaseColumnConfig>();
		
		ColumnConfig idColumn = new ColumnConfig(MessageEventDefinition.id.getLabel(), MessageEventDefinition.id.toString());
		
		this.msgRefColumn = new ColumnConfig(MessageEventDefinition.messageRef.getLabel(), MessageEventDefinition.messageRef.toString());
		
		this.operationRefColumn = new ColumnConfig(MessageEventDefinition.operation.getLabel(), MessageEventDefinition.operation.toString());
		
		
		cc.add(idColumn);
		cc.add(msgRefColumn);
		cc.add(operationRefColumn);
		
		
		return cc;
	}

	public ColumnConfig getMsgRefColumn() {
		return msgRefColumn;
	}
	
	public ColumnConfig getOperationRefColumn() {
		return operationRefColumn;
	}
	
	@Override
	protected FieldDef[] getFieldDef() {
		return new FieldDef[]{
				new StringFieldDef(MessageEventDefinition.id.toString()),
				new ObjectFieldDef(MessageEventDefinition.messageRef.toString()),
				new ObjectFieldDef(MessageEventDefinition.operation.toString())
		};
	}
	
	@Override
	protected EditorGridPanel getGridPanel() {
		return super.getGridPanel();
	}

}
