/**
 * definitions-editor - BPMN Definitions Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.definitionseditor.imports;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.infrastructure.IImportBean;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.AbstractEditableGrid;
import com.ebmwebsourcing.petalsbpm.definitionseditor.Helper;
import com.ebmwebsourcing.petalsbpm.definitionseditor.Constants.ImportProperties;
import com.ebmwebsourcing.petalsbpm.definitionseditor.imports.events.ImportPanelHandler;
import com.ebmwebsourcing.petalsbpm.definitionseditor.imports.events.SelectAvailableImportEvent;
import com.gwtext.client.core.EventObject;
import com.gwtext.client.data.ArrayReader;
import com.gwtext.client.data.FieldDef;
import com.gwtext.client.data.MemoryProxy;
import com.gwtext.client.data.ObjectFieldDef;
import com.gwtext.client.data.Record;
import com.gwtext.client.data.RecordDef;
import com.gwtext.client.data.Store;
import com.gwtext.client.data.StringFieldDef;
import com.gwtext.client.widgets.Button;
import com.gwtext.client.widgets.ToolbarButton;
import com.gwtext.client.widgets.event.ButtonListenerAdapter;
import com.gwtext.client.widgets.form.ComboBox;
import com.gwtext.client.widgets.form.event.ComboBoxListenerAdapter;
import com.gwtext.client.widgets.grid.BaseColumnConfig;
import com.gwtext.client.widgets.grid.ColumnConfig;
import com.gwtext.client.widgets.grid.EditorGridPanel;
import com.gwtext.client.widgets.grid.GridEditor;

public class ImportPanel extends AbstractEditableGrid<IImportBean>{

	private ComboBox importCombo;
	private Store cbStore;
	private ArrayReader reader;
	

	
	public ImportPanel(List<IImportBean> data) {
		super(data);
		


		
	}

	@Override
	protected void buildGrid() {
		super.buildGrid();
		gridPanel.setClicksToEdit(0);
		gridPanel.setAutoExpandColumn(2);
		gridPanel.getView().setForceFit(true);
		ToolbarButton uploadBtn  = new ToolbarButton("Upload",new ButtonListenerAdapter(){
			@Override
			public void onClick(Button button, EventObject e) {
				
				
				
			}
		});
		




		
		gridPanel.getTopToolbar().addButton(uploadBtn);
		
		gridPanel.doLayout();
	}
	
	
	@Override
	protected void bind(Record record, IImportBean value) {
		// TODO Auto-generated method stub
		
	}

	@Override
	protected String getAddText() {
		return "Add Import";
	}

	@Override
	protected IImportBean getNewDefaultRecord() {
		return Helper.getNewImport();
	}

	@Override
	protected String getRemoveText() {
		return "Remove Import";
	}
	
	public ComboBox getImportType() {
		return importCombo;
	}
	
	@Override
	protected Object[] convertDataToObject(IImportBean data) {
		
		Object[] object = new Object[3];
		
		object[0] = data.getImportType();
		object[1] = data.getLocation();
		object[2] = data.getNamespace();
		
		return object;
	}

	@Override
	protected List<BaseColumnConfig> getColumnsConfig() {
		
		initWidgets();
		
		ArrayList<BaseColumnConfig> cc 		= new ArrayList<BaseColumnConfig>();

		
		//Import
		ColumnConfig importColumn 			= new ColumnConfig(ImportProperties.Import.getLabel(), ImportProperties.Import.toString());
		importColumn.setEditor(new GridEditor(this.importCombo));
		

		//Import type
		ColumnConfig importTypeColumn 		= new ColumnConfig(ImportProperties.importType.getLabel(), ImportProperties.importType.toString()); 
		
		
		//Namespace
		ColumnConfig namespaceColumn 		= new ColumnConfig(ImportProperties.namespace.getLabel(), ImportProperties.namespace.toString());
		
		cc.add(importColumn);
		cc.add(importTypeColumn);		
		cc.add(namespaceColumn);
		
		return cc;
	}	

	private void initWidgets(){
		
		RecordDef recordDef 	= new RecordDef(  
                new FieldDef[]{  
                        new StringFieldDef("label"),
                        new ObjectFieldDef("value")
                }  
        );  
		
		MemoryProxy proxy 		= new MemoryProxy(new Object[0][2]);  
		
		this.reader = new ArrayReader(recordDef);  
		this.cbStore = new Store(proxy, reader);  
		store.load();
		
		  

		this.importCombo = new ComboBox();  
		
		this.importCombo.setDisplayField("label");  
		this.importCombo.setStore(cbStore); 
		this.importCombo.setMode(ComboBox.LOCAL);
		this.importCombo.setEditable(false);
//		this.importType.setForceSelection(true);
		this.importCombo.setAllowBlank(false);
		this.importCombo.addListener(new ComboBoxListenerAdapter(){
			
			@Override
			public void onSelect(ComboBox comboBox, Record record, int index) {
				
				IImportBean importBean = (IImportBean) record.getAsObject("value");
				
				fireEvent(new SelectAvailableImportEvent(importBean));
				
			}
			
			
		});
		
	}
	
	protected Store getCbStore() {
		return cbStore;
	}
	
	public ArrayReader getReader() {
		return reader;
	}
	
	@Override
	protected FieldDef[] getFieldDef() {
		return new FieldDef[]{
				
				new StringFieldDef(ImportProperties.Import.toString()),
				new StringFieldDef(ImportProperties.importType.toString()),
				new StringFieldDef(ImportProperties.namespace.toString()),
			};
	}

	
	@Override
	protected EditorGridPanel getGridPanel() {
		return super.getGridPanel();
	}
	
	public void addImportPanelHandler(ImportPanelHandler handler){
		addHandler(handler, SelectAvailableImportEvent.TYPE);
	}
	
}
