/**
 * definitions-editor - BPMN Definitions Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.definitionseditor.itemdefinition;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.common.IItemDefinitionBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.infrastructure.IDefinitionsBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.common.ItemDefinitionBean;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.AddElementEvent;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.AfterEditRecordEvent;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.BeforeEditRecordEvent;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.CellClickEvent;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.EditableGridHandler;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.RemoveElementEvent;
import com.ebmwebsourcing.petalsbpm.definitionseditor.common.AbstractController;
import com.ebmwebsourcing.petalsbpm.definitionseditor.definitions.events.AddItemDefinitionEvent;
import com.ebmwebsourcing.petalsbpm.definitionseditor.definitions.events.AddMessageEvent;
import com.gwtext.client.widgets.grid.GridEditor;

/**
 * @TODO Once a row have been validated => consider it as added into the definition
 *  									=> it cannot be edited anymore
 * @author nfleury
 *
 */
public class ItemDefinitionController extends AbstractController implements EditableGridHandler {


	private ItemDefinitionPanel panel;
	
	private List<IItemDefinitionBean> validItems;
	
	private List<String> qnames;
	
	public ItemDefinitionController(ItemDefinitionPanel panel,List<String> qnames) {
		super();
		
		this.qnames     = qnames;
		this.panel	 	= panel;
		
		this.validItems	= new ArrayList<IItemDefinitionBean>();
		
		panel.addHandler(this);
		
		init();
	}
	
	private void init(){
		
		this.panel.getStructurerefColumn().setEditor(new GridEditor(new StructureRefComboBox(qnames)));
		
	}

	@Override
	public void onAddElement(AddElementEvent<?> event) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onAfterEditRecord(AfterEditRecordEvent<?> event) {
	
		validate(panel.getValues());
		
	}

	private void validate(List<IItemDefinitionBean> itemDefinitions){
		
		for(IItemDefinitionBean id:itemDefinitions){
			
			if (id.getStructureRef()!=null && id.getItemKind()!=null && validItems.contains(id)==false){
				
				validItems.add(id);
				
				fireEvent(new AddItemDefinitionEvent(id));
				
			}
			
		}
		
	}
	
	
	@Override
	public void onBeforeEditorRecord(BeforeEditRecordEvent<?> event) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onRemoveElement(RemoveElementEvent<?> event) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onCellClick(CellClickEvent event) {
		// TODO Auto-generated method stub
		
	}
	
	
}
