/**
 * definitions-editor - BPMN Definitions Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.definitionseditor.itemdefinition;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.Constants.ItemKind;
import com.gwtext.client.data.ArrayReader;
import com.gwtext.client.data.FieldDef;
import com.gwtext.client.data.MemoryProxy;
import com.gwtext.client.data.RecordDef;
import com.gwtext.client.data.Store;
import com.gwtext.client.data.StringFieldDef;
import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.form.ComboBox;
import com.gwtext.client.widgets.form.event.ComboBoxListenerAdapter;

public class ItemKindComboBox extends ComboBox {

	private ArrayReader reader;
	private Store cbStore;

	public ItemKindComboBox() {
		
		initGUI();
		
		this.addListener(new ComboBoxListenerAdapter(){
			
			@Override
			public boolean doBeforeShow(Component component) {

				load();

				return true;
			}
			
		});
		
	}
	
	private void load(){
		
		this.cbStore.removeAll();
		
		MemoryProxy proxy 	= new MemoryProxy(getItemKinds());
		
		Store storeTemp 	= new Store(proxy,this.reader);
		storeTemp.reload();
		
		this.cbStore.add(storeTemp.getRecords());
		
		
	}
	
	private void initGUI(){
		
		RecordDef recordDef 	= new RecordDef(  
                new FieldDef[]{  
                        new StringFieldDef("label")
                }  
        );  
		
		MemoryProxy proxy 		= new MemoryProxy(new Object[0][1]);  
		
		this.reader = new ArrayReader(recordDef);  
		this.cbStore = new Store(proxy, reader);  

		this.setDisplayField("label");  
		this.setStore(cbStore); 
		this.setMode(ComboBox.LOCAL);
		this.setEditable(false);
		this.setForceSelection(true);
		this.setAllowBlank(false);
		
	}
	
	private Object[][] getItemKinds(){
		
		Object[][] objs = new Object[ItemKind.values().length][1];
		
		for(int i=0;i<ItemKind.values().length;i++){
			
			objs[i][0] = ItemKind.values()[i].value();
			
		}
		
		return objs;
	}
	
}
