/**
 * definitions-editor - BPMN Definitions Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.definitionseditor.message;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.common.IItemDefinitionBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.common.IMessageBean;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.AddElementEvent;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.AfterEditRecordEvent;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.BeforeEditRecordEvent;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.CellClickEvent;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.EditableGridHandler;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.RemoveElementEvent;
import com.ebmwebsourcing.petalsbpm.definitionseditor.Constants.Message;
import com.ebmwebsourcing.petalsbpm.definitionseditor.common.AbstractController;
import com.ebmwebsourcing.petalsbpm.definitionseditor.definitions.events.AddMessageEvent;
import com.ebmwebsourcing.petalsbpm.definitionseditor.itemdefinition.ItemDefinitionRefComboBox;
import com.gwtext.client.data.Record;
import com.gwtext.client.widgets.form.ComboBox;
import com.gwtext.client.widgets.form.event.ComboBoxListenerAdapter;
import com.gwtext.client.widgets.grid.GridEditor;

public class MessageController extends AbstractController implements EditableGridHandler{
	
	private MessagePanel msgPanel;
	private List<IItemDefinitionBean> items;
	private List<IMessageBean> validMsgs;
	private Record actualRecord;
	
	
	public MessageController(MessagePanel msgPanel,List<IItemDefinitionBean> items) {
		
		this.msgPanel 	= msgPanel;
		this.items	  	= items;
		this.validMsgs 	= new ArrayList<IMessageBean>();
		
		msgPanel.addHandler(this);
		
		init();
	}
	
	private void init(){
		
		ItemDefinitionRefComboBox itemRef = new ItemDefinitionRefComboBox(items);
		itemRef.setLabel("Item Ref");
		
		//change itemRef value in actual record otherwise default implementation will return a string
		itemRef.addListener(new ComboBoxListenerAdapter(){
			@Override
			public void onSelect(ComboBox comboBox, Record record, int index) {
				
				actualRecord.set(Message.itemRef.toString(), record.getAsObject("value"));
			
			}
		});
		
		this.msgPanel.getItemRefColumn().setEditor(new GridEditor(itemRef));
		
	}

	@Override
	public void onAddElement(AddElementEvent<?> event) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onAfterEditRecord(AfterEditRecordEvent<?> event) {
		
		validate(msgPanel.getValues());
		
	}
	
	private void validate(List<IMessageBean> msgs){
		
		for(IMessageBean msg:msgs){

			if (msg.getName()!=null && msg.getItemDefinition()!=null && validMsgs.contains(msg)==false){
				
				validMsgs.add(msg);
				
				fireEvent(new AddMessageEvent(msg));
				
			}
			
		}
		
	}
	
	@Override
	public void onBeforeEditorRecord(BeforeEditRecordEvent<?> event) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onRemoveElement(RemoveElementEvent<?> event) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onCellClick(CellClickEvent event) {
		this.actualRecord = msgPanel.getGridPanel().getStore().getAt(event.getRowIndex());
	}
	
	
	
	
	
}
