/**
 * definitions-editor - BPMN Definitions Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.definitionseditor.util;

import java.util.HashMap;
import java.util.List;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.common.IErrorBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.common.IItemDefinitionBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.common.IMessageBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.foundation.IBPMNElementBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.infrastructure.IImportBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.service.IInterfaceBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.service.IOperationBean;

public class DefinitionReferenceHelper {
	
	private HashMap<IImportBean,List<IBPMNElementBean>> importRefs;
	
	private static DefinitionReferenceHelper instance;
	
	private DefinitionReferenceHelper() {
		this.importRefs = new HashMap<IImportBean, List<IBPMNElementBean>>();
	}
	
	public static DefinitionReferenceHelper getInstance() {
		if (instance==null) instance=new DefinitionReferenceHelper();
		return instance;
	}
	
	
	public List<BPMNElementReference> getImportRefs(IImportBean importBean){
		//TODO:
		return null;
	}
	
	
	public List<IInterfaceBean> getInterfaces(){
		return null;
	}
	
	public List<IOperationBean> getOperations(){
		return null;
	}
	
	public List<IMessageBean> getMessages(){
		return null;
	}
	
	public List<IItemDefinitionBean> getItemDefinitions(){
		return null;
	}
	
	public List<IErrorBean> getErrors(){
		return null;
	}
	
	
	public class BPMNElementReference{
		
		private String id;
		private String type;
		private String name;
		
		public String getId() {
			return id;
		}
		public void setId(String id) {
			this.id = id;
		}
		public String getType() {
			return type;
		}
		public void setType(String type) {
			this.type = type;
		}
		public String getName() {
			return name;
		}
		public void setName(String name) {
			this.name = name;
		}
		
		
		
	}
	
	
}
