/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.validation;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.collaboration.ICollaborationBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.collaboration.ILaneBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.collaboration.ILaneSetBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.common.IFlowElementBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.common.IParticipantBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.IProcessBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.activity.ITaskBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.data.IExpressionBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.event.IEndEventBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.event.IStartEventBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.event.definition.IEventDefinitionBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.gateway.IGatewayBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.gateway.ISequenceFlowBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.mock.IdGenerator;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.mock.MockDefinitionsDB;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.collaboration.CollaborationBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.collaboration.LaneBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.collaboration.LaneSetBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.common.ParticipantBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.infrastructure.DefinitionsBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.ProcessBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.activity.SendTaskBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.activity.TaskBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.data.ExpressionBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.event.EndEventBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.event.StartEventBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.event.definition.MessageEventDefinitionBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.gateway.ExclusiveGatewayBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.gateway.ParallelGatewayBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.gateway.SequenceFlowBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.validation.BPMNValidationException;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.validation.BPMNValidator;
import junit.framework.Assert;
import org.junit.Test;

public class ValidationTest {
    @Test
    public void testExamples() {
        System.out.println("------------------------------------------------------------------");
        System.out.println("test EXAMPLES");
        for (DefinitionsBean defs : MockDefinitionsDB.getAllExamples()) {
            System.out.println("Validating " + defs.getId());
            this.checkNoError(defs);
        }
    }

    @Test
    public void testInvalid() {
        System.out.println("------------------------------------------------------------------");
        System.out.println("test INVALID");
        DefinitionsBean defs = new DefinitionsBean(IdGenerator.createUniqueId());
        CollaborationBean collab = new CollaborationBean(IdGenerator.createUniqueId());
        defs.addCollaboration((ICollaborationBean)collab);
        this.checkError(defs, collab.getId(), BPMNValidator.BPMNValidationErrorMessage.NO_POOL);
        ParticipantBean pool = new ParticipantBean(IdGenerator.createUniqueId());
        collab.addParticipant((IParticipantBean)pool);
        this.checkError(defs, pool.getId(), BPMNValidator.BPMNValidationErrorMessage.EMPTY_POOL);
        ProcessBean process = new ProcessBean(IdGenerator.createUniqueId());
        pool.setProcess((IProcessBean)process);
        defs.addProcess((IProcessBean)process);
        this.checkError(defs, pool.getId(), BPMNValidator.BPMNValidationErrorMessage.EMPTY_POOL);
        LaneSetBean laneSet = new LaneSetBean(IdGenerator.createUniqueId());
        process.addLaneSet((ILaneSetBean)laneSet);
        this.checkError(defs, pool.getId(), BPMNValidator.BPMNValidationErrorMessage.EMPTY_POOL);
        LaneBean lane = new LaneBean(IdGenerator.createUniqueId());
        laneSet.addLane((ILaneBean)lane);
        this.checkError(defs, lane.getId(), BPMNValidator.BPMNValidationErrorMessage.EMPTY_LANE);
        StartEventBean start = new StartEventBean(IdGenerator.createUniqueId());
        lane.addStartEvent((IStartEventBean)start);
        process.addStartEvent((IStartEventBean)start);
        this.checkError(defs, start.getId(), BPMNValidator.BPMNValidationErrorMessage.START_NO_OUTGOING);
        ExclusiveGatewayBean eg = new ExclusiveGatewayBean(IdGenerator.createUniqueId());
        lane.addGateway((IGatewayBean)eg);
        process.addGateway((IGatewayBean)eg);
        SequenceFlowBean sf1 = new SequenceFlowBean(IdGenerator.createUniqueId());
        sf1.setSourceNode((IFlowElementBean)start);
        sf1.setTargetNode((IFlowElementBean)eg);
        process.addSequenceFlow((ISequenceFlowBean)sf1);
        this.checkError(defs, eg.getId(), BPMNValidator.BPMNValidationErrorMessage.GATEWAY_NO_OUTGOING);
        TaskBean t = new TaskBean(IdGenerator.createUniqueId());
        lane.addTask((ITaskBean)t);
        process.addTask((ITaskBean)t);
        SequenceFlowBean sf2 = new SequenceFlowBean(IdGenerator.createUniqueId());
        sf2.setSourceNode((IFlowElementBean)eg);
        sf2.setTargetNode((IFlowElementBean)t);
        ExpressionBean expsf2 = new ExpressionBean(IdGenerator.createUniqueId());
        expsf2.setContent("conditionSF2");
        sf2.setExpression((IExpressionBean)expsf2);
        process.addSequenceFlow((ISequenceFlowBean)sf2);
        this.checkError(defs, eg.getId(), BPMNValidator.BPMNValidationErrorMessage.FORWARDING_GATE);
        SendTaskBean st = new SendTaskBean(IdGenerator.createUniqueId());
        lane.addTask((ITaskBean)st);
        process.addTask((ITaskBean)st);
        SequenceFlowBean sf3 = new SequenceFlowBean(IdGenerator.createUniqueId());
        sf3.setSourceNode((IFlowElementBean)eg);
        sf3.setTargetNode((IFlowElementBean)st);
        ExpressionBean expsf3 = new ExpressionBean(IdGenerator.createUniqueId());
        expsf3.setContent("conditionSF3");
        sf3.setExpression((IExpressionBean)expsf3);
        process.addSequenceFlow((ISequenceFlowBean)sf3);
        this.checkError(defs, st.getId(), BPMNValidator.BPMNValidationErrorMessage.NO_MSG_SEND_TASK);
        EndEventBean end = new EndEventBean(IdGenerator.createUniqueId());
        lane.addEndEvent((IEndEventBean)end);
        process.addEndEvent((IEndEventBean)end);
        SequenceFlowBean sf4 = new SequenceFlowBean(IdGenerator.createUniqueId());
        sf4.setSourceNode((IFlowElementBean)st);
        sf4.setTargetNode((IFlowElementBean)end);
        process.addSequenceFlow((ISequenceFlowBean)sf4);
        this.checkError(defs, st.getId(), BPMNValidator.BPMNValidationErrorMessage.NO_MSG_SEND_TASK);
        end.addResult((IEventDefinitionBean)new MessageEventDefinitionBean(IdGenerator.createUniqueId()));
        this.checkNoError(defs);
        SequenceFlowBean sf5 = new SequenceFlowBean(IdGenerator.createUniqueId());
        sf5.setSourceNode((IFlowElementBean)st);
        process.addSequenceFlow((ISequenceFlowBean)sf5);
        this.checkError(defs, sf5.getId(), BPMNValidator.BPMNValidationErrorMessage.SF_NO_TARGET);
        process.removeSequenceFlow((ISequenceFlowBean)sf5);
        ParallelGatewayBean pg = new ParallelGatewayBean(IdGenerator.createUniqueId());
        lane.addGateway((IGatewayBean)pg);
        process.addGateway((IGatewayBean)pg);
        SequenceFlowBean sf6 = new SequenceFlowBean(IdGenerator.createUniqueId());
        sf6.setTargetNode((IFlowElementBean)st);
        sf6.setSourceNode((IFlowElementBean)pg);
        process.addSequenceFlow((ISequenceFlowBean)sf6);
        this.checkError(defs, pg.getId(), BPMNValidator.BPMNValidationErrorMessage.GATEWAY_NO_INCOMING);
        SequenceFlowBean sf7 = new SequenceFlowBean(IdGenerator.createUniqueId());
        sf7.setSourceNode((IFlowElementBean)t);
        sf7.setTargetNode((IFlowElementBean)pg);
        process.addSequenceFlow((ISequenceFlowBean)sf7);
        this.checkError(defs, pg.getId(), BPMNValidator.BPMNValidationErrorMessage.FORWARDING_GATE);
        SequenceFlowBean sf8 = new SequenceFlowBean(IdGenerator.createUniqueId());
        sf8.setSourceNode((IFlowElementBean)pg);
        sf8.setTargetNode((IFlowElementBean)end);
        ExpressionBean expsf8 = new ExpressionBean(IdGenerator.createUniqueId());
        expsf8.setContent("expsf8");
        sf8.setExpression((IExpressionBean)expsf8);
        process.addSequenceFlow((ISequenceFlowBean)sf8);
        this.checkError(defs, sf8.getId(), BPMNValidator.BPMNValidationErrorMessage.SF_PARRALLEL_GATE_CONDITION);
        sf8.setExpression(null);
        this.checkNoError(defs);
    }

    private void checkError(DefinitionsBean defs, String id, BPMNValidator.BPMNValidationErrorMessage msg) {
        try {
            BPMNValidator.getInstance().validate(defs);
        }
        catch (BPMNValidationException e) {
            System.out.println(e.getValidationErrors());
            Assert.assertEquals((int)1, (int)e.getValidationErrors().size());
            Assert.assertTrue((boolean)e.getValidationErrors().containsKey(id));
            Assert.assertEquals((String)msg.getMessage(), (String)((String)e.getValidationErrors().get(id)));
            return;
        }
        Assert.fail((String)"Validation should have failed.");
    }

    private void checkNoError(DefinitionsBean defs) {
        try {
            BPMNValidator.getInstance().validate(defs);
        }
        catch (BPMNValidationException e) {
            System.out.println(e.getValidationErrors());
            Assert.fail((String)"Validation should not have failed.");
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)"An unexpected error happened.");
        }
    }
}

