/**
 * domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.mock;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.Constants.ProcessTypes;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.collaboration.LaneBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.collaboration.LaneSetBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.common.MessageBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.infrastructure.DefinitionsBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.infrastructure.NamespaceDeclaration;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.ProcessBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.activity.ServiceTaskBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.activity.TaskBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.data.ExpressionBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.event.EndEventBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.event.StartEventBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.event.definition.EventDefinitionBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.event.definition.MessageEventDefinitionBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.gateway.ExclusiveGatewayBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.gateway.ParallelGatewayBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.gateway.SequenceFlowBean;
import com.ebmwebsourcing.geasyschema.domain.api.ISchema;
import com.ebmwebsourcing.geasyschema.domain.mock.SchemaMockDB;

/**
 * 
 * @author nfleury
 *
 */
public class PrivateProcessMockDB {

	public static String PROCESS1_ID;
	public static String PROCESS1_EL1_ID;
	public static String PROCESS1_EL2_ID;
	public static String PROCESS1_EL3_ID;
	public static String PROCESS1_EL4_ID;
	public static String PROCESS1_EL5_ID;
	public static String PROCESS1_EL6_ID;
	public static String PROCESS1_EL7_ID;
	public static String PROCESS1_EL8_ID;
	public static String PROCESS1_EL9_ID;
	public static String PROCESS1_EL10_ID;
	public static String PROCESS1_EL11_ID;
	public static String PROCESS1_EL12_ID;
	public static String PROCESS1_EL13_ID;
	public static String PROCESS1_EL14_ID;
	public static String PROCESS1_EL15_ID;
	public static String PROCESS1_EL16_ID;
	public static String PROCESS1_EL17_ID;
	public static String PROCESS1_EL18_ID;
	public static String PROCESS1_EL19_ID;
	public static String PROCESS1_EL20_ID;
	public static String PROCESS1_EL21_ID;
	public static String PROCESS1_EL22_ID;
	
	
	public static DefinitionsBean getProcess1(){
		
		DefinitionsBean def = new DefinitionsBean(IdGenerator.createUniqueId());
		
		
		//Definition attributes
		def.setTargetNamespace("http://com.ebmwebsourcing.easybpmn/creatingIdea/definition");
		def.setTypeLanguage("http://www.w3.org/2001/XMLSchema");
		def.setExpressionLanguage("http://www.w3.org/1999/XPath");
		
		ISchema importedSchema = SchemaMockDB.getSchema1();

		//Add a namespace declaration
		NamespaceDeclaration nsd1 = new NamespaceDeclaration("xsdImport1", importedSchema.getTargetNamespace());
		
		//Add some imports
//		XSDImportBean impt = new XSDImportBean(nsd1, importedSchema);
//		impt.setLocation("location");
//		def.addImport(impt);
		
		
		PROCESS1_ID = IdGenerator.createUniqueId();
		ProcessBean process = new ProcessBean(PROCESS1_ID);
		process.setName("Quotation Handling");
		process.setType(ProcessTypes.PUBLIC);
		
		def.addProcess(process);

		//Create Lane
		LaneBean lane = new LaneBean(IdGenerator.createUniqueId());
		lane.setName("Internal role");

		
		//Create lane set and add it into process
		LaneSetBean laneSet = new LaneSetBean(IdGenerator.createUniqueId());

		laneSet.addLane(lane);
		
		process.addLaneSet(laneSet);

		
		//EL1
		PROCESS1_EL1_ID = IdGenerator.createUniqueId();
		StartEventBean startEvent = new StartEventBean(PROCESS1_EL1_ID);
		EventDefinitionBean ed = new MessageEventDefinitionBean(IdGenerator.createUniqueId());
		((MessageEventDefinitionBean)ed).setMessage(new MessageBean(IdGenerator.createUniqueId()));
		startEvent.addTrigger(ed);
		def.addEventDefinition(ed);

		lane.addStartEvent(startEvent);
		process.addStartEvent(startEvent);
		
		//EL2
		PROCESS1_EL2_ID = IdGenerator.createUniqueId();
		TaskBean task1 = new TaskBean(PROCESS1_EL2_ID);
		task1.setName("Quotation Handling");
		
		lane.addTask(task1);
		process.addTask(task1);
		
		//EL3
		PROCESS1_EL3_ID = IdGenerator.createUniqueId();
		ServiceTaskBean task2 = new ServiceTaskBean(PROCESS1_EL3_ID);
		task2.setName("Approve Order");
		
		lane.addTask(task2);
		process.addTask(task2);
		
		//EL4
		PROCESS1_EL4_ID = IdGenerator.createUniqueId();
		ExclusiveGatewayBean exclusiveGw1 = new ExclusiveGatewayBean(PROCESS1_EL4_ID);
		
		lane.addGateway(exclusiveGw1);
		process.addGateway(exclusiveGw1);
		
		//EL5
		PROCESS1_EL5_ID = IdGenerator.createUniqueId();
		EndEventBean endEvent1 = new EndEventBean(PROCESS1_EL5_ID);
		
		lane.addEndEvent(endEvent1);
		process.addEndEvent(endEvent1);
		
		//EL6
		PROCESS1_EL6_ID = IdGenerator.createUniqueId();
		ParallelGatewayBean pgwt1 = new ParallelGatewayBean(PROCESS1_EL6_ID);
		
		lane.addGateway(pgwt1);
		process.addGateway(pgwt1);
		
		//EL7
		PROCESS1_EL7_ID = IdGenerator.createUniqueId();
		TaskBean task3 = new TaskBean(PROCESS1_EL7_ID);
		task3.setName("Order Handling");
		
		lane.addTask(task3);
		process.addTask(task3);
		
		//EL8
		PROCESS1_EL8_ID = IdGenerator.createUniqueId();
		TaskBean task4 = new TaskBean(PROCESS1_EL8_ID);
		task4.setName("Shipping handling");
		
		lane.addTask(task4);
		process.addTask(task4);
		
		//EL9
		PROCESS1_EL9_ID = IdGenerator.createUniqueId();
		ParallelGatewayBean pgwt2 = new ParallelGatewayBean(PROCESS1_EL9_ID);
		
		lane.addGateway(pgwt2);
		process.addGateway(pgwt2);
		
		//EL10
		PROCESS1_EL10_ID = IdGenerator.createUniqueId();
		ServiceTaskBean task5 = new ServiceTaskBean(PROCESS1_EL10_ID);
		task5.setName("Review Order");
		
		lane.addTask(task5);
		process.addTask(task5);
		
		//EL11
		PROCESS1_EL11_ID = IdGenerator.createUniqueId();
		EndEventBean endEvent2 = new EndEventBean(PROCESS1_EL11_ID);
		
		lane.addEndEvent(endEvent2);
		process.addEndEvent(endEvent2);
		
		//EL12
		PROCESS1_EL12_ID = IdGenerator.createUniqueId();
		SequenceFlowBean sf1 = new SequenceFlowBean(PROCESS1_EL12_ID);
		sf1.setSourceNode(startEvent);
		sf1.setTargetNode(task1);
		
		process.addSequenceFlow(sf1);
		
		//EL13
		PROCESS1_EL13_ID = IdGenerator.createUniqueId();
		SequenceFlowBean sf2 = new SequenceFlowBean(PROCESS1_EL13_ID);
		sf2.setSourceNode(task1);
		sf2.setTargetNode(task2);		
		
		process.addSequenceFlow(sf2);
		
		//EL14
		PROCESS1_EL14_ID = IdGenerator.createUniqueId();
		SequenceFlowBean sf3 = new SequenceFlowBean(PROCESS1_EL14_ID);
		sf3.setSourceNode(task2);
		sf3.setTargetNode(exclusiveGw1);
		
		process.addSequenceFlow(sf3);
		
		//EL15
		PROCESS1_EL15_ID = IdGenerator.createUniqueId();
		SequenceFlowBean sf4 = new SequenceFlowBean(PROCESS1_EL15_ID);
		ExpressionBean expSF4 = new ExpressionBean(IdGenerator.createUniqueId());
		expSF4.setContent("Rejected");
		sf4.setExpression(expSF4);
		sf4.setSourceNode(exclusiveGw1);
		sf4.setTargetNode(endEvent1);
		
		process.addSequenceFlow(sf4);
		
		//EL16
		PROCESS1_EL16_ID = IdGenerator.createUniqueId();
		SequenceFlowBean sf5 = new SequenceFlowBean(PROCESS1_EL16_ID);
		ExpressionBean expSF5 = new ExpressionBean(IdGenerator.createUniqueId());
		expSF5.setContent("Approved");
		sf5.setExpression(expSF5);
		sf5.setSourceNode(exclusiveGw1);
		sf5.setTargetNode(pgwt1);
		
		process.addSequenceFlow(sf5);
		
		//EL17
		PROCESS1_EL17_ID = IdGenerator.createUniqueId();
		SequenceFlowBean sf6 = new SequenceFlowBean(PROCESS1_EL17_ID);
		sf6.setSourceNode(pgwt1);
		sf6.setTargetNode(task3);
		
		process.addSequenceFlow(sf6);
		
		//EL18
		PROCESS1_EL18_ID = IdGenerator.createUniqueId();
		SequenceFlowBean sf7 = new SequenceFlowBean(PROCESS1_EL18_ID);
		sf7.setSourceNode(pgwt1);
		sf7.setTargetNode(task4);
		
		process.addSequenceFlow(sf7);
		
		//EL19
		PROCESS1_EL19_ID = IdGenerator.createUniqueId();
		SequenceFlowBean sf8 = new SequenceFlowBean(PROCESS1_EL19_ID);
		sf8.setSourceNode(task3);
		sf8.setTargetNode(pgwt2);
		
		process.addSequenceFlow(sf8);
		
		//EL20
		PROCESS1_EL20_ID = IdGenerator.createUniqueId();
		SequenceFlowBean sf9 = new SequenceFlowBean(PROCESS1_EL20_ID);
		sf9.setSourceNode(task4);
		sf9.setTargetNode(pgwt2);
		
		process.addSequenceFlow(sf9);
		
		//EL20
		PROCESS1_EL21_ID = IdGenerator.createUniqueId();
		SequenceFlowBean sf10 = new SequenceFlowBean(PROCESS1_EL21_ID);
		sf10.setSourceNode(pgwt2);
		sf10.setTargetNode(task5);
		
		process.addSequenceFlow(sf10);
		
		//EL22
		PROCESS1_EL22_ID = IdGenerator.createUniqueId();
		SequenceFlowBean sf11 = new SequenceFlowBean(PROCESS1_EL22_ID);
		sf11.setSourceNode(task5);
		sf11.setTargetNode(endEvent2);
		
		process.addSequenceFlow(sf11);
		
		return def;
	}
	
	
	
	
	
}
