/**
 * domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.collaboration.ICollaborationBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.collaboration.ILaneBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.collaboration.ILaneSetBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.common.ICallableElementBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.common.IErrorBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.common.IFlowElementBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.common.IFlowNodeBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.common.IItemDefinitionBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.common.IMessageBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.common.IMessageFlowBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.common.IParticipantBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.common.IPartnerRoleBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.foundation.IBaseElementBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.infrastructure.IDefinitionsBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.infrastructure.IImportBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.infrastructure.xsd.IBPMN20ImportBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.IProcessBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.activity.ICallActivityBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.activity.ITaskBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.data.IAssignmentBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.data.IDataAssociationBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.data.IDataInputAssociationBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.data.IDataOutputAssociationBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.data.IExpressionBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.data.WithDataInputAssociationBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.data.WithDataOutputAssociationBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.event.IEndEventBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.event.IIntermediateCatchEventBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.event.IIntermediateThrowEventBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.event.IStartEventBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.event.definition.IEventDefinitionBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.gateway.IGatewayBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.gateway.ISequenceFlowBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.service.IInterfaceBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.service.IOperationBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.collaboration.CollaborationBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.collaboration.LaneBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.collaboration.LaneSetBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.common.ErrorBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.common.FlowElementBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.common.MessageBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.common.MessageFlowBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.common.ParticipantBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.foundation.BaseElementBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.infrastructure.DefinitionsBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.infrastructure.xsd.BPMN20ImportBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.infrastructure.xsd.WSDLImportBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.infrastructure.xsd.XSDImportBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.ProcessBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.activity.ActivityBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.activity.TaskBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.data.DataInputAssociationBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.data.DataOutputAssociationBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.data.ExpressionBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.event.EndEventBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.event.StartEventBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.event.definition.EventDefinitionBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.gateway.GatewayBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.gateway.SequenceFlowBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.service.InterfaceBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.service.OperationBean;
import com.ebmwebsourcing.geasyschema.domain.api.IElement;
import com.ebmwebsourcing.geasywsdl.domain.api.IOperation;
import com.ebmwebsourcing.geasywsdl.domain.api.IPortType;

public class DefinitionsHelper {

	private static DefinitionsHelper instance;
	
	private int i;
	
	public static DefinitionsHelper getInstance(){
		if(instance==null){
			instance = new DefinitionsHelper();
		}
		return instance;
	}
	
	public String createUniqueId(){
		i++;
		return new Date().getTime()+"id"+i;
	}
	
	
	public List<String> getImportedStructureRefQnames(IDefinitionsBean defs){

		List<String> result = new ArrayList<String>();
		
		for(IImportBean ib:defs.getImports()){
			
			if (ib instanceof XSDImportBean){
				
				XSDImportBean xsdIb = (XSDImportBean) ib;
				
				for(IElement element:xsdIb.getSchema().getElements()){
					
					result.add(ib.getNSDeclaration().getPrefix()+":"+element.getName());
				
				}
			
			}
			
		}
		
		return result;
	}
	
	
	public List<String> getImportedWSDLImplementationRefQnames(IDefinitionsBean defs){
        
        List<String> result = new ArrayList<String>();
        
        for(IImportBean ib:defs.getImports()){
            
            if (ib instanceof WSDLImportBean){
                
                WSDLImportBean wsdlIb = (WSDLImportBean) ib;
                
                for(IPortType pt:wsdlIb.getWSDLDefinitions().getPortTypes()){
                    
                    result.add(ib.getNSDeclaration().getPrefix()+":"+pt.getName());
                    
                }
                
            }
            
        }
        
        return result;
    }
    
    public List<String> getImportedWSDLOperationsRefQnames(IDefinitionsBean defs){
        
        List<String> result = new ArrayList<String>();
        
        for(IImportBean ib:defs.getImports()){
            
            if (ib instanceof WSDLImportBean){
                
                WSDLImportBean wsdlIb = (WSDLImportBean) ib;
                
                for(IPortType pt:wsdlIb.getWSDLDefinitions().getPortTypes()){
                    
                    for(IOperation o:pt.getOperations()){
                        
                        result.add(ib.getNSDeclaration().getPrefix()+":"+o.getName());  
                        
                    }
                    
                    
                }
                
            }
            
        }
        
        return result;
    }
	
	
	public IProcessBean getParentProcess(IFlowElementBean fe, IDefinitionsBean defs){
        for(IProcessBean p : defs.getProcesses()){
            for(IFlowElementBean elt : p.getFlowNodes()){
                if(fe.getId().equals(elt.getId())){
                    return p;
                }
            }
            for(ISequenceFlowBean sf : p.getSequenceFlows()) {
                if(fe.getId().equals(sf.getId())){
                    return p;
                }
            }
        }
        return null;
    }
	
	
	public List<ISequenceFlowBean> getOutgoingSequenceFlows(IFlowNodeBean fn, IDefinitionsBean defs) {
	    IProcessBean proc = getParentProcess(fn, defs);
	    if(proc==null) {
	        return null;
	    }
	    List<ISequenceFlowBean> result = new ArrayList<ISequenceFlowBean>();
	    for(ISequenceFlowBean sf : proc.getSequenceFlows()) {
	    	
	    	if (sf.getSourceNode()==null) continue;
	        if(sf.getSourceNode().getId().equals(fn.getId())) {
	            result.add(sf);
	        }
	    
	    }
	    return result;
	}
	
	public List<ICallableElementBean> getCallableElements(IDefinitionsBean defs){
		
		List<ICallableElementBean> result = new ArrayList<ICallableElementBean>();
		
		//add processes that are embedded in current definitions
		result.addAll(defs.getProcesses());
		
		//add process that have been imported
		for(IImportBean i:defs.getImports()){
			
			if (i instanceof IBPMN20ImportBean){
				
				IBPMN20ImportBean bpmnImport = (IBPMN20ImportBean) i;
				
				result.addAll(bpmnImport.getBPMN20Definitions().getProcesses());
				
			}
			
			
		}

		return result;
	}
	
	
	public BaseElementBean getElementById(DefinitionsBean defs, String id){
		try{
			return (BaseElementBean) new SearchingVisitor(defs).getElementById(id);
		}
		catch(Exception e){
			e.printStackTrace();
			return null;
		}
	}
	
	public BaseElementBean getElementById(IDefinitionsBean defs, String id, String namespace) {
	    if(namespace==null) {
	        return getElementById((DefinitionsBean) defs, id);
	    }
	    for(IImportBean impt : defs.getImports()) {
	        if(impt instanceof BPMN20ImportBean && impt.getNamespace().equals(namespace)) {
	           return getElementById((DefinitionsBean) ((BPMN20ImportBean)impt).getBPMN20Definitions(), id); 
	        }
	    }
	    return null;
    }
	
	public void addBean(BaseElementBean bean, BaseElementBean receiver, String addMethod){
//		if(receiver instanceof DefinitionsBean){
//			if(bean instanceof CollaborationBean){
//				((DefinitionsBean)receiver).addCollaboration((CollaborationBean)bean);
//			}
//		}
//		else
		if(receiver instanceof CollaborationBean){
			if(bean instanceof ParticipantBean){
				((CollaborationBean)receiver).addParticipant((ParticipantBean)bean);
			}
			else if(bean instanceof MessageFlowBean){
				((CollaborationBean)receiver).addMessageFlow((MessageFlowBean)bean);
			}
		}
		else if(receiver instanceof ProcessBean){
			if(bean instanceof LaneSetBean){
				((ProcessBean)receiver).addLaneSet((LaneSetBean)bean);
			}
			else if(bean instanceof SequenceFlowBean){
				((ProcessBean)receiver).addSequenceFlow((SequenceFlowBean)bean);
			}
		}
		else if(receiver instanceof InterfaceBean){
			if(bean instanceof OperationBean){
				((InterfaceBean)receiver).addOperation((OperationBean)bean);
			}
		}
		else if(receiver instanceof OperationBean){
			if(bean instanceof MessageBean){
				if(addMethod.equals("setMessageIn")){
					((OperationBean)receiver).setMessageIn((MessageBean)bean);
				}
				else if(addMethod.equals("setMessageOut")){
					((OperationBean)receiver).setMessageOut((MessageBean)bean);
				}
				else if(addMethod.equals("addError")){
					((OperationBean)receiver).addError((ErrorBean)bean);
				}
			}
		}
		else if(receiver instanceof LaneSetBean){
			if(bean instanceof LaneBean){
				((LaneSetBean)receiver).addLane((LaneBean) bean);
			}
		}
		else if(receiver instanceof LaneBean){
			if(bean instanceof TaskBean){
				((LaneBean)receiver).addTask((TaskBean)bean);
			}
			else if(bean instanceof GatewayBean){
				((LaneBean)receiver).addGateway((GatewayBean)bean);
			}
			else if(bean instanceof StartEventBean){
				((LaneBean)receiver).addStartEvent((StartEventBean)bean);
			}
			else if(bean instanceof EndEventBean){
				((LaneBean)receiver).addEndEvent((EndEventBean)bean);
			}
		}
		else if(receiver instanceof SequenceFlowBean){
			if(bean instanceof ExpressionBean){
				((SequenceFlowBean)receiver).setExpression((ExpressionBean)bean);
			}
		}
		else if(receiver instanceof StartEventBean){
			if(bean instanceof EventDefinitionBean){
				((StartEventBean)receiver).addTrigger((EventDefinitionBean)bean);
			}
		}
		else if(receiver instanceof EndEventBean){
			if(bean instanceof EventDefinitionBean){
				((EndEventBean)receiver).addResult((EventDefinitionBean)bean);
			}
		}
		else if(receiver instanceof ActivityBean){
			if(bean instanceof DataInputAssociationBean){
				((ActivityBean)receiver).addDataInputAssociation((DataInputAssociationBean)bean);
			}
			else if(bean instanceof DataOutputAssociationBean){
				((ActivityBean)receiver).addDataOutputAssociation((DataOutputAssociationBean)bean);
			}
		}
	}
	
	
	
	public void removeBean(BaseElementBean bean, BaseElementBean parent, String removeMethod) {
//		if(parent instanceof DefinitionsBean){
//			if(bean instanceof CollaborationBean){
//				((DefinitionsBean)parent).removeCollaboration((CollaborationBean)bean);
//			}
//		}
//		else 
		if(parent instanceof CollaborationBean){
			if(bean instanceof ParticipantBean){
				((CollaborationBean)parent).removeParticipant((ParticipantBean)bean);
			}
			else if(bean instanceof MessageFlowBean){
				((CollaborationBean)parent).removeMessageFlow((MessageFlowBean)bean);
			}
		}
		else if(parent instanceof ProcessBean){
			if(bean instanceof LaneSetBean){
				((ProcessBean)parent).removeLaneSet((LaneSetBean)bean);
			}
			else if(bean instanceof SequenceFlowBean){
				((ProcessBean)parent).removeSequenceFlow((SequenceFlowBean)bean);
			}
		}
		else if(parent instanceof InterfaceBean){
			if(bean instanceof OperationBean){
				((InterfaceBean)parent).removeOperation((OperationBean)bean);
			}
		}
		else if(parent instanceof OperationBean){
			if(bean instanceof ErrorBean){
				((OperationBean)parent).removeError((ErrorBean)bean);
			}
		}
		else if(parent instanceof LaneSetBean){
			if(bean instanceof LaneBean){
				((LaneSetBean)parent).removeLane((LaneBean) bean);
			}
		}
		else if(parent instanceof LaneBean){
			if(bean instanceof FlowElementBean){
				((LaneBean)parent).removeFlowElement((FlowElementBean)bean);
			}
		}
		else if(parent instanceof ActivityBean){
			if(bean instanceof DataInputAssociationBean){
				((ActivityBean)parent).removeDataInputAssociation((DataInputAssociationBean)bean);
			}
			else if(bean instanceof DataOutputAssociationBean){
				((ActivityBean)parent).removeDataOutputAssociation((DataOutputAssociationBean)bean);
			}
		}
	}
	
	
	
	public IFlowElementBean getFlowNodeById(String id, ProcessBean proc){
		if(proc.getLaneSets()!=null){
			for(ILaneSetBean lsb : proc.getLaneSets()){
				for(ILaneBean l : lsb.getLanes()){
					for(IFlowElementBean fe : l.getFlowNodes()){
						if(fe.getId().equals(id)){
							return fe;
						}
					}
				}
			}
		}
		return null;
	}
	
	
	
	private class SearchingVisitor extends DefinitionsBeanVisitor{
		private IBaseElementBean bean;
		private String id;
		
		public SearchingVisitor(DefinitionsBean defs){
			super(defs);
		}
		
		public IBaseElementBean getElementById(String id) throws Exception{
			this.id = id;
			this.bean = null;
			visitDefinitionsByPools();
			return bean;
		}
		
		@Override
		public void visitProcess(IProcessBean pb) {
		    if(pb.getId().equals(this.id) && bean==null){bean = pb;}
		}
		@Override
		public void visitParticipant(IParticipantBean participant) {
			if(participant.getId().equals(this.id) && bean==null){bean = participant;}
		}
		@Override
		public void visitParticipantInterface(IInterfaceBean itf){
			if(itf.getId().equals(this.id) && bean==null){bean = itf;}
		}
		@Override
		public void visitParticipantProcess(IProcessBean proc, IParticipantBean participant){
			if(proc.getId().equals(this.id) && bean==null){bean = proc;}
		}
		@Override
		public void visitMessageFlow(IMessageFlowBean mfb) {
			if(mfb.getId().equals(this.id) && bean==null){bean = mfb;}
		}
		@Override
		public void visitCollaboration(ICollaborationBean collab) {
			if(collab.getId().equals(this.id) && bean==null){bean = collab;}
		}
		@Override
		public void visitSequenceFlow(ISequenceFlowBean sfb) {
			if(sfb.getId().equals(this.id) && bean==null){bean = sfb;}
		}
		@Override
		public void visitGateway(IGatewayBean gb) {
			if(gb.getId().equals(this.id) && bean==null){bean = gb;}
		}
		@Override
		public void visitEndEvent(IEndEventBean eeb) {
			if(eeb.getId().equals(this.id) && bean==null){bean = eeb;}
		}
		@Override
		public void visitTask(ITaskBean tb) {
			if(tb.getId().equals(this.id) && bean==null){bean = tb;}
		}
		@Override
		public void visitCallActivity(ICallActivityBean ca) {
		    if(ca.getId().equals(this.id) && bean==null){bean = ca;}
		}
		@Override
		public void visitIntermediateThrowEvent(IIntermediateThrowEventBean e) {
			if(e.getId().equals(this.id) && bean==null){bean = e;}
		}
		@Override
		public void visitIntermediateCatchEvent(IIntermediateCatchEventBean e) {
			if(e.getId().equals(this.id) && bean==null){bean = e;}
		}
		@Override
		public void visitDataInputAssociation(IDataInputAssociationBean dia, WithDataInputAssociationBean owner){
			if(dia.getId().equals(this.id) && bean==null){bean = dia;}
		}
		@Override
		public void visitDataOutputAssociation(IDataOutputAssociationBean doa, WithDataOutputAssociationBean owner){
			if(doa.getId().equals(this.id) && bean==null){bean = doa;}
		}
		@Override
		public void visitAssignement(IAssignmentBean a, IDataAssociationBean da) {
			if(a.getId().equals(this.id) && bean !=null){bean = a;}
			if(a.getTo()!=null){
				visitSFExpression(a.getTo());
			}
			if(a.getFrom()!=null){
				visitSFExpression(a.getFrom());
			}
		}
		@Override
		public void visitStartEvent(IStartEventBean seb) {
			if(seb.getId().equals(this.id) && bean==null){bean = seb;}
		}
		@Override
		public void visitLane(ILaneBean lane) {
			if(lane.getId().equals(this.id) && bean==null){bean = lane;}
		}
		@Override
		public void visitLaneSet(ILaneSetBean laneSet) {
			if(laneSet.getId().equals(this.id) && bean==null){bean = laneSet;}
		}
		@Override
		public void visitOperation(IOperationBean op) {
			if(op.getId().equals(this.id) && bean==null){bean = op;}
		}
		@Override
		public void visitItemDefinition(IItemDefinitionBean itemDefinition) {
			if(itemDefinition.getId().equals(this.id) && bean==null){bean = itemDefinition;}
		}
		@Override
		public void visitSFExpression(IExpressionBean exp){
			if(exp.getId().equals(this.id) && bean==null){bean = exp;}
		}
		@Override
		public void visitPartnerRole(IPartnerRoleBean partnerRole) {
			if(partnerRole.getId().equals(this.id) && bean==null){bean = partnerRole;}
		}
		@Override
		public void visitChildLaneSet(ILaneSetBean lsb) {
			if(lsb.getId().equals(this.id) && bean==null){bean = lsb;}
		}
		@Override
		public void visitMessageFlowMessage(IMessageBean msg) {
			if(msg.getId().equals(this.id) && bean==null){bean = msg;}
		}
		@Override
		public void visitOperationMessageIn(IMessageBean msg,IOperationBean opBean) {
			if(msg.getId().equals(this.id) && bean==null){bean = msg;}
		}
		@Override
		public void visitOperationMessageOut(IMessageBean msg,IOperationBean opBean) {
			if(msg.getId().equals(this.id) && bean==null){bean = msg;}
		}
		@Override
		public void visitOperationError(IErrorBean msg,IOperationBean opBean) {
			if(msg.getId().equals(this.id) && bean==null){bean = msg;}
		}
		@Override
		public void visitEventDefinition(IEventDefinitionBean ed){
		    if(ed.getId().equals(this.id) && bean==null){bean = ed;}
		}
	}

}
