/**
 * domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.collaboration;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.collaboration.ILaneBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.collaboration.ILaneSetBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.common.IFlowElementBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.activity.ITaskBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.event.IEndEventBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.event.IStartEventBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.gateway.IGatewayBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.foundation.BaseElementBean;



public class LaneSetBean extends BaseElementBean implements ILaneSetBean{

	private List<ILaneBean> lanes;

	public LaneSetBean(String id){
		super(id);
	}
	
	public LaneSetBean(){
		super();
		lanes = new ArrayList<ILaneBean>();
	}
	
	public void addLane(ILaneBean l){
		if(lanes==null){
			lanes = new ArrayList<ILaneBean>();
		}
		lanes.add(l);
	}
	
	public void removeLane(ILaneBean l){
		if(lanes!=null){
			lanes.remove(l);
		}
	}
	////////////////////////////////////////////
	/////                                  /////
	/////       GETTERS AND SETTERS        /////
	/////                                  /////
	////////////////////////////////////////////
	public List<ILaneBean> getLanes() {
		return lanes;
	}

	public void setLanes(List<ILaneBean> lanes) {
		this.lanes = lanes;
	}
	
	public List<? extends IFlowElementBean> getFlowNodes() {
		List<IFlowElementBean> nodes = null;
		List<ILaneBean> lanes =getLanes();
		if(lanes!=null && lanes.size()>0){
			nodes = new ArrayList<IFlowElementBean>();
			for(ILaneBean lane : lanes){
				nodes.addAll(lane.getFlowNodes());
			}
		}
		return nodes;
	}

	public List<IStartEventBean> getStartEvents(){
		List<IStartEventBean> nodes = null;
		nodes = new ArrayList<IStartEventBean>();
		if(lanes!=null){
			for(ILaneBean lane : lanes){
				nodes.addAll(lane.getStartEvents());
				if(lane.getChildLaneSet()!=null){
					nodes.addAll(lane.getChildLaneSet().getStartEvents());
				}
			}
		}
		return nodes;
	}

    public List<IEndEventBean> getEndEvents(){
		List<IEndEventBean> nodes = null;
		nodes = new ArrayList<IEndEventBean>();
		if(lanes!=null && lanes.size()>0){
			for(ILaneBean lane : lanes){
				nodes.addAll(lane.getEndEvents());
				if(lane.getChildLaneSet()!=null){
					nodes.addAll(lane.getChildLaneSet().getEndEvents());
				}
			}
		}
		return nodes;
	}

    public List<IGatewayBean> getGateways(){
		List<IGatewayBean> gateways = null;
		gateways = new ArrayList<IGatewayBean>();
		if(lanes!=null && lanes.size()>0){
			for(ILaneBean lane : lanes){
				gateways.addAll(lane.getGateways());
				if(lane.getChildLaneSet()!=null){
					gateways.addAll(lane.getChildLaneSet().getGateways());
				}
			}
		}
		return gateways;
	}

    public List<ITaskBean> getTasks(){
		List<ITaskBean> nodes = null;
		nodes = new ArrayList<ITaskBean>();
		if(lanes!=null && lanes.size()>0){
			for(ILaneBean lane : lanes){
				nodes.addAll(lane.getTasks());
				if(lane.getChildLaneSet()!=null){
					nodes.addAll(lane.getChildLaneSet().getTasks());
				}
			}
		}
		return nodes;
	}

//	public List<SequenceFlowBean> getSequenceFlows(){
//		List<SequenceFlowBean> sequenceFlows = null;
//		sequenceFlows = new ArrayList<SequenceFlowBean>();
//		if(lanes!=null && lanes.size()>0){
//			for(LaneBean lane : lanes){
//				sequenceFlows.addAll(lane.getSequenceFlows());
//				if(lane.getChildLaneSet()!=null){
//					sequenceFlows.addAll(lane.getChildLaneSet().getSequenceFlows());
//				}
//			}
//		}
//		return sequenceFlows;
//	}
}
