/**
 * domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.common;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.common.IItemDefinitionBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.common.IMessageBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.foundation.BaseElementBean;

public class MessageBean extends BaseElementBean implements IMessageBean{
	
	private String name;
	private IItemDefinitionBean itemDefinition;
	
	public MessageBean(String id){
		super(id);
	}
	
	public MessageBean(){
		super();
	}
	////////////////////////////////////////////
	/////                                  /////
	/////       GETTERS AND SETTERS        /////
	/////                                  /////
	////////////////////////////////////////////
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public IItemDefinitionBean getItemDefinition() {
		return itemDefinition;
	}
	public void setItemDefinition(IItemDefinitionBean itemDefinition) {
		this.itemDefinition = itemDefinition;
	}
	
	@Override
	public String toString() {
		return "["+this.getId()+":"+this.getName()+"]";
	}
	
}
