/**
 * domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.common;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.common.IParticipantBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.IProcessBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.service.IEndPointBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.service.IInterfaceBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.foundation.BaseElementBean;

public class ParticipantBean extends BaseElementBean implements IParticipantBean{

	private List<IInterfaceBean> interfaces;
	private IProcessBean process;
	private String name;
	private int minimumMultiplicity;
	private int maximumMultiplicity;
	private List<IEndPointBean> endpoints;

	public ParticipantBean(String id){
		super(id);
		this.setInterfaces(new ArrayList<IInterfaceBean>());
		endpoints = new ArrayList<IEndPointBean>();
		minimumMultiplicity = 0;
		maximumMultiplicity = 1;
	}
	
	public ParticipantBean(){
		super();
		this.setInterfaces(new ArrayList<IInterfaceBean>());
		endpoints = new ArrayList<IEndPointBean>();
		minimumMultiplicity = 0;
        maximumMultiplicity = 1;
	}
	
	public void addInterface(IInterfaceBean i){
		interfaces.add(i);
	}
	
	public void removeInterface(IInterfaceBean i){
		interfaces.remove(i);
	}
	
	public void setMultiplicity(int minNumberOfinstances, int maxNumberOfInstances){
	    if(minNumberOfinstances < 0){
	        throw new IllegalArgumentException("The minimum multiplicity of participant must be positive.");
	    }
	    if(maxNumberOfInstances < minNumberOfinstances){
	        throw new IllegalArgumentException("Inconsistent values : min ("+minNumberOfinstances+") > max ("+maxNumberOfInstances+")");
	    }
	    this.minimumMultiplicity = minNumberOfinstances;
	    this.maximumMultiplicity = maxNumberOfInstances;
	}
	
	public void addEndPoint(IEndPointBean ep){
	    endpoints.add(ep);
	}
	
	public void removeEndPoint(IEndPointBean ep){
        endpoints.add(ep);
    }
	////////////////////////////////////////////
	/////                                  /////
	/////       GETTERS AND SETTERS        /////
	/////                                  /////
	////////////////////////////////////////////
	public void setProcess(IProcessBean process) {
		this.process = process;
	}
	public IProcessBean getProcess() {
		return process;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public void setInterfaces(List<IInterfaceBean> interfaces) {
		this.interfaces = interfaces;
	}
	public List<IInterfaceBean> getInterfaces() {
		return interfaces;
	}
    public int getMinNumberOfInstances() {
        return minimumMultiplicity;
    }
    public void setMinNumberOfInstances(int minNumberOfInstances) {
        this.minimumMultiplicity = minNumberOfInstances;
    }
    public int getMinimumMultiplicity() {
        return minimumMultiplicity;
    }
    public void setMinimumMultiplicity(int minimumMultiplicity) {
        this.minimumMultiplicity = minimumMultiplicity;
    }
    public int getMaximumMultiplicity() {
        return maximumMultiplicity;
    }
    public void setMaximumMultiplicity(int maximumMultiplicity) {
        this.maximumMultiplicity = maximumMultiplicity;
    }
    public List<IEndPointBean> getEndPoints() {
        return endpoints;
    }
    public void setEndPoints(List<IEndPointBean> endpoints) {
        this.endpoints = endpoints;
    }
	
}
