/**
 * domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.foundation.graphics;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.foundation.BaseElementBean;

public abstract class GraphicElementBean extends BaseElementBean {
	
	private int x_left,y_left,x_right,y_right;
	private List<Waypoint> waypoints;
	
	
	public GraphicElementBean(String id){
		super(id);
		x_left = 0;
		y_left = 0;
		x_right = 0;
		y_right = 0;
	}
	
	public GraphicElementBean(){
		super();
		x_left = 0;
		y_left = 0;
		x_right = 0;
		y_right = 0;
	}
	
	public void setPosition(int x_l, int y_l, int width, int height){
		x_left = x_l;
		y_left = y_l;
		x_right = x_l+width;
		y_right = y_l+height;
	}
	
	public int getWidth(){
		return (x_right -x_left);
	}
	
	public int getHeight(){
		return (y_right - y_left);
	}
	
	public void addWaypoint(Waypoint wp){
		if(waypoints==null){
			waypoints = new ArrayList<Waypoint>();
		}
		waypoints.add(wp);
	}
	
	public void removeWaypoint(Waypoint wp){
		if(waypoints==null){
			return;
		}
		waypoints.remove(wp);
	}
	////////////////////////////////////////////
	/////                                  /////
	/////       GETTERS AND SETTERS        /////
	/////                                  /////
	////////////////////////////////////////////
	public int getX_left() {
		return x_left;
	}

	public void setX_left(int xLeft) {
		x_left = xLeft;
	}

	public int getY_left() {
		return y_left;
	}

	public void setY_left(int yLeft) {
		y_left = yLeft;
	}

	public int getX_right() {
		return x_right;
	}

	public void setX_right(int xRight) {
		x_right = xRight;
	}

	public int getY_right() {
		return y_right;
	}

	public void setY_right(int yRight) {
		y_right = yRight;
	}

	public List<Waypoint> getWaypoints() {
		return waypoints;
	}
	
	public void setWaypoints(List<Waypoint> wps) {
		waypoints = wps;
	}
}
