/**
 * domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.event;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.data.IDataOutputAssociationBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.data.IDataOutputBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.event.ICatchEventBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.event.definition.IEventDefinitionBean;



public abstract class CatchEventBean extends EventBean implements ICatchEventBean {
	
	private List<IEventDefinitionBean> triggers;
	private List<IDataOutputBean> dataOutputs;
	private List<IDataOutputAssociationBean> dataOutputAssociations;

	public CatchEventBean(String id){
		super(id);
		triggers = new ArrayList<IEventDefinitionBean>();
		dataOutputAssociations = new ArrayList<IDataOutputAssociationBean>();
		dataOutputs = new ArrayList<IDataOutputBean>();
	}
	
	public CatchEventBean(){
		super();
		triggers = new ArrayList<IEventDefinitionBean>();
		dataOutputAssociations = new ArrayList<IDataOutputAssociationBean>();
		dataOutputs = new ArrayList<IDataOutputBean>();
	}
	
	public void addTrigger(IEventDefinitionBean e){
		triggers.add(e);
	}
	
	public void removeTrigger(IEventDefinitionBean e){
		triggers.remove(e);
	}
	public void addDataOutput(IDataOutputBean d){
		dataOutputs.add(d);
	}
	public void removeDataOutput(IDataOutputBean d){
		dataOutputs.remove(d);
	}
	public void addDataOutputAssociation(IDataOutputAssociationBean d){
		dataOutputAssociations.add(d);
	}
	public void removeDataOutputAssociation(IDataOutputAssociationBean d){
		dataOutputAssociations.remove(d);
	}
	////////////////////////////////////////////
	/////                                  /////
	/////       GETTERS AND SETTERS        /////
	/////                                  /////
	////////////////////////////////////////////
	public List<IEventDefinitionBean> getTriggers() {
		return triggers;
	}
	public void setTriggers(List<IEventDefinitionBean> triggers) {
		this.triggers = triggers;
	}
	public List<IDataOutputBean> getDataOutputs() {
		return dataOutputs;
	}
	public void setDataOutputs(List<IDataOutputBean> dataOutputs) {
		this.dataOutputs = dataOutputs;
	}
	public List<IDataOutputAssociationBean> getDataOutputAssociations() {
		return dataOutputAssociations;
	}
	public void setDataOutputAssociations(List<IDataOutputAssociationBean> dataOutputAssociations) {
		this.dataOutputAssociations = dataOutputAssociations;
	}
	
}
