/**
 * domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.event.definition;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.common.IMessageBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.event.definition.IMessageEventDefinitionBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.service.IOperationBean;

public class MessageEventDefinitionBean extends EventDefinitionBean implements
        IMessageEventDefinitionBean, StartEventDefinitionBean, EndEventDefinitionBean,
        IntermediateCatchEventDefinitionBean, IntermediateThrowEventDefinitionBean {

    private IMessageBean message;
    private IOperationBean operation;
    
    public MessageEventDefinitionBean() {
        super();
    }

    public MessageEventDefinitionBean(String id) {
        super(id);
    }

    public IMessageBean getMessage() {
        return message;
    }

    public void setMessage(IMessageBean msg) {
        this.message = msg;
    }

	@Override
	public IOperationBean getOperation() {
		return operation;
	}

	@Override
	public void setOperation(IOperationBean operation) {
		this.operation = operation;
	}

}
