/**
 * domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


package com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.gateway;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.Constants.EventGatewayType;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.gateway.IEventBasedGatewayBean;

public class EventBasedGatewayBean extends GatewayBean implements IEventBasedGatewayBean {

    private boolean instantiate;

    private EventGatewayType type;

    public EventBasedGatewayBean() {
        super();
        type = EventGatewayType.Exclusive;
    }

    public EventBasedGatewayBean(String id) {
        super(id);
        type = EventGatewayType.Exclusive;
    }

    public boolean isInstantiate() {
        return instantiate;
    }

    public void setInstantiate(boolean instantiate) {
        this.instantiate = instantiate;
    }

    public EventGatewayType getType() {
        return type;
    }

    public void setType(EventGatewayType type) {
        this.type = type;
    }

}
