/**
 * domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.gateway;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.common.IFlowElementBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.gateway.IGatewayBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.common.FlowNodeBean;




public abstract class GatewayBean extends FlowNodeBean implements IGatewayBean {
	
	private List<IFlowElementBean> incomingActivities;
	private List<IFlowElementBean> outgoingActivities;

	
	public GatewayBean(String id){
		super(id);
	}
	
	public GatewayBean(){
		super();
		incomingActivities = new ArrayList<IFlowElementBean>();
		outgoingActivities = new ArrayList<IFlowElementBean>();
	}
	
	public void addIncomingActivity(IFlowElementBean feb){
		if(incomingActivities==null){
			incomingActivities = new ArrayList<IFlowElementBean>();
		}
		incomingActivities.add(feb);
	}
	
	public void addOutgoingActivity(IFlowElementBean feb){
		if(outgoingActivities==null){
			outgoingActivities = new ArrayList<IFlowElementBean>();
		}
		outgoingActivities.add(feb);
	}
	////////////////////////////////////////////
	/////                                  /////
	/////       GETTERS AND SETTERS        /////
	/////                                  /////
	////////////////////////////////////////////
	public List<IFlowElementBean> getIncomingActivities() {
		return incomingActivities;
	}
	public void setIncomingActivities(List<IFlowElementBean> incomingActivities) {
		this.incomingActivities = incomingActivities;
	}
	public List<IFlowElementBean> getOutgoingActivities() {
		return outgoingActivities;
	}
	public void setOutgoingActivities(List<IFlowElementBean> outgoingActivities) {
		this.outgoingActivities = outgoingActivities;
	}
	
}
