/**
 * domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.service;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.common.IErrorBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.common.IMessageBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.service.IOperationBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.foundation.BaseElementBean;



public class OperationBean extends BaseElementBean implements IOperationBean {
    
	private String name;
	private IMessageBean messageIn;
	private IMessageBean messageOut;
	private List<IErrorBean> errors;
	private String implementationRef;
	
	public OperationBean(String id){
		super(id);
	}
	
	public OperationBean(){
		super();
		errors = new ArrayList<IErrorBean>();
	}
	
	public void addError(IErrorBean msg){
		if(errors==null){
			errors = new ArrayList<IErrorBean>();
		}
		errors.add(msg);
	}
	
	public void removeError(IErrorBean msg){
		if(errors!=null){
			errors.remove(msg);
		}
	}
	////////////////////////////////////////////
	/////                                  /////
	/////       GETTERS AND SETTERS        /////
	/////                                  /////
	////////////////////////////////////////////
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public IMessageBean getMessageIn() {
		return messageIn;
	}
	public void setMessageIn(IMessageBean messageIn) {
		this.messageIn = messageIn;
	}
	public IMessageBean getMessageOut() {
		return messageOut;
	}
	public void setMessageOut(IMessageBean messageOut) {
		this.messageOut = messageOut;
	}
	public List<IErrorBean> getErrors() {
		return errors;
	}
	public void setErrors(List<IErrorBean> errorMasseges) {
		this.errors = errorMasseges;
	}
    public String getWsdlImplementationRef() {
        return implementationRef;
    }
    public void setWsdlImplementationRef(String implementationRef) {
        this.implementationRef = implementationRef;
    }
	
    @Override
    public String toString() {
    	return this.getId()+":"+this.getName();
    }
    
}
