/**
 * domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.validation;

import java.util.HashMap;
import java.util.Map;

public class BPMNValidationException extends Exception{

	private Map<String, String> validationErrors;
	
	
	public BPMNValidationException(Map<String, String> validationErrors){
		super();
		this.validationErrors = validationErrors;
	}
	
	/**
	 * Only for serialization
	 */
	protected BPMNValidationException(){
		super();
		this.validationErrors = new HashMap<String, String>();
	}

	public Map<String, String> getValidationErrors() {
		return validationErrors;
	}

	public void setValidationErrors(Map<String, String> validationErrors) {
		this.validationErrors = validationErrors;
	}
	
	public String getAllErrorsMessage(){
		StringBuffer sb = new StringBuffer();
		for(String errorMsg : validationErrors.values()){
			sb.append(errorMsg);
			sb.append("<br>");
		}
		return sb.toString();
	}
}
