/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.bpmneditor.server.service.bpmn2.clientToServer;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.choreography.IChoreographyBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.common.IParticipantBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.infrastructure.IDefinitionsBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.infrastructure.IImportBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.infrastructure.INamespaceDeclaration;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.service.IInterfaceBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.choreography.ChoreographyBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.common.ParticipantBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.infrastructure.DefinitionsBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.infrastructure.NamespaceDeclaration;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.infrastructure.xsd.BPMN20ImportBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.service.InterfaceBean;
import com.ebmwebsourcing.bpmneditor.server.service.bpmn2.clientToServer.ClientToServer;
import com.ebmwebsourcing.easybox.api.XmlObjectWriteException;
import com.ebmwebsourcing.easybpmn.bpmn20.api.BPMNException;
import com.ebmwebsourcing.easybpmn.bpmn20.api.DefinitionsHelper;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Import;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Participant;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.junit.Test;

public class ImportedElementsTest {
    @Test
    public void testImportedInterface() throws BPMNException, XmlObjectWriteException {
        DefinitionsBean importedDefs = new DefinitionsBean("importedDefs");
        importedDefs.setTargetNamespace("TNS");
        NamespaceDeclaration nsd = new NamespaceDeclaration("prefix", importedDefs.getTargetNamespace());
        BPMN20ImportBean impt = new BPMN20ImportBean((INamespaceDeclaration)nsd, (IDefinitionsBean)importedDefs);
        InterfaceBean itfb = new InterfaceBean("itfb");
        itfb.setNSDeclaration((INamespaceDeclaration)nsd);
        importedDefs.addInterface((IInterfaceBean)itfb);
        DefinitionsBean mainDefs = new DefinitionsBean("mainDefs");
        mainDefs.addImport((IImportBean)impt);
        mainDefs.addImportNSDeclaration((INamespaceDeclaration)nsd);
        ChoreographyBean chor = new ChoreographyBean("chor");
        mainDefs.addChoreography((IChoreographyBean)chor);
        ParticipantBean participant = new ParticipantBean("participant");
        participant.addInterface((IInterfaceBean)itfb);
        chor.addParticipant((IParticipantBean)participant);
        Definitions defs = ClientToServer.adapt((DefinitionsBean)mainDefs);
        Assert.assertTrue((defs.getInterfaces() == null || defs.getInterfaces().length == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)defs.hasImport());
        Assert.assertEquals((int)1, (int)defs.getImports().length);
        Import i = defs.getImports()[0];
        Assert.assertTrue((boolean)i.isBPMN20Import());
        Participant p = (Participant)DefinitionsHelper.findObjectInDefinitions((Definitions)defs, (String)participant.getId(), Participant.class);
        Assert.assertNotNull((Object)p);
        Assert.assertTrue((boolean)p.hasInterfaceRef());
        Assert.assertEquals((int)1, (int)p.getInterfaceRef().length);
        QName ref = p.getInterfaceRef()[0];
        Assert.assertEquals((String)nsd.getURI(), (String)ref.getNamespaceURI());
        Assert.assertEquals((String)nsd.getPrefix(), (String)ref.getPrefix());
        Assert.assertEquals((String)itfb.getId(), (String)ref.getLocalPart());
    }
}

