/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.bpmneditor.server.service.bpmn2.serverToClient;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.collaboration.ICollaborationBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.IProcessBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.infrastructure.DefinitionsBean;
import com.ebmwebsourcing.bpmneditor.server.service.bpmn2.serverToClient.ServerToClient;
import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectNode;
import com.ebmwebsourcing.easybox.api.XmlObjectXPathEvaluator;
import com.ebmwebsourcing.easybox.api.with.WithId;
import com.ebmwebsourcing.easybpmn.bpmn20.api.BPMNException;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Assignment;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Collaboration;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.DataInputAssociation;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.EndEvent;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.EventDefinition;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Expression;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.FlowElement;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.FlowNode;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Import;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Interface;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ItemDefinition;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Lane;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.LaneSet;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Message;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.MessageEventDefinition;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.MessageFlow;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Operation;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ParallelGateway;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Participant;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.PartnerRole;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Process;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ReceiveTask;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.RootElement;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.SequenceFlow;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.StartEvent;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TItemKind;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TProcessType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import net.sf.saxon.type.SchemaException;
import org.junit.Test;

public class TestServerToClient {
    private XmlContext context;

    @Test
    public void testAdaption() throws Exception {
        XmlObjectNode[] defsNodes;
        Definitions defs = null;
        DefinitionsBean defsBean = null;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        defs = this.buildSerververSideModel();
        defs.getXmlContext().createWriter().writeDocument((XmlObject)defs, (OutputStream)os);
        System.out.println(os.toString());
        defsBean = ServerToClient.adapt((Definitions)defs);
        Assert.assertNotNull((Object)defsBean);
        Assert.assertEquals((String)defs.getId(), (String)defsBean.getId());
        Assert.assertEquals((String)defs.getTargetNamespace(), (String)defsBean.getTargetNamespace());
        Assert.assertEquals((int)defs.getCollaborations().length, (int)defsBean.getCollaborations().size());
        Assert.assertEquals((int)defs.getCollaborations()[0].getMessageFlow().length, (int)((ICollaborationBean)defsBean.getCollaborations().get(0)).getMessageFlows().size());
        Assert.assertNotNull((Object)((ICollaborationBean)defsBean.getCollaborations().get(0)).getParticipants());
        Assert.assertEquals((int)1, (int)((ICollaborationBean)defsBean.getCollaborations().get(0)).getParticipants().size());
        Assert.assertEquals((int)defs.getCollaborations()[0].getParticipant().length, (int)((ICollaborationBean)defsBean.getCollaborations().get(0)).getParticipants().size());
        Assert.assertNotNull((Object)defsBean.getProcesses());
        Assert.assertEquals((int)defs.getProcesses().length, (int)defsBean.getProcesses().size());
        Assert.assertEquals((int)defs.getProcesses()[0].getFlowElement().length, (int)(((IProcessBean)defsBean.getProcesses().get(0)).getFlowNodes().size() + ((IProcessBean)defsBean.getProcesses().get(0)).getSequenceFlows().size()));
        Assert.assertEquals((int)defs.getProcesses()[0].getFlowElementsByClass(SequenceFlow.class).size(), (int)((IProcessBean)defsBean.getProcesses().get(0)).getSequenceFlows().size());
        Assert.assertEquals((int)defs.getMessages().length, (int)defsBean.getMessages().size());
        Definitions d = (Definitions)defs.getXmlContext().createReader().readDocument((InputStream)new ByteArrayInputStream(os.toByteArray()), Definitions.class);
        XmlObjectXPathEvaluator xpe = defs.getXmlContext().createXPathEvaluator();
        for (XmlObjectNode defsNode : defsNodes = xpe.selectXmlObjectNodes((XmlObject)defs, "//*", XmlObjectNode.class)) {
            String id;
            if (!(defsNode instanceof WithId) || (id = ((WithId)defsNode).getId()) == null) continue;
            XmlObjectNode[] dNode = xpe.selectXmlObjectNodes((XmlObject)d, "//*[@id='" + id + "']", XmlObjectNode.class);
            Assert.assertNotNull((Object)dNode);
            Assert.assertEquals((String)id, (int)1, (int)dNode.length);
            Assert.assertNotNull((String)id, (Object)dNode[0]);
            Assert.assertEquals(defsNode.getClass(), dNode[0].getClass());
            Assert.assertEquals((Object)defsNode.getXmlObjectQName(), (Object)dNode[0].getXmlObjectQName());
            Assert.assertEquals((String)id, (String)defsNode.getXmlObjectTextContent(), (String)dNode[0].getXmlObjectTextContent());
        }
    }

    private Definitions buildSerververSideModel() throws BPMNException, URISyntaxException, SchemaException {
        Definitions def = this.newInstance(Definitions.class);
        def.setTargetNamespace("namespace");
        Import impt = this.newInstance(Import.class);
        impt.setImportType("importType");
        impt.setLocation("location");
        impt.setNamespace("tns");
        def.addImport(impt);
        Message msg = this.newInstance(Message.class);
        msg.setId("msgId");
        msg.setName("MESSAGE");
        def.addRootElement((RootElement)msg);
        Interface itf = this.newInstance(Interface.class);
        def.addRootElement((RootElement)itf);
        itf.setId("itfId");
        itf.setName("INTERFACE");
        Operation op = this.newInstance(Operation.class);
        itf.addOperation(op);
        op.setName("OPERATION");
        op.setInMessageRef(new QName(msg.getId()));
        ItemDefinition id = this.newInstance(ItemDefinition.class);
        id.setId("itemDefintionId");
        id.setIsCollection(false);
        id.setItemKind(TItemKind.Information);
        id.setStructureRef(new QName("tns", "input"));
        msg.setItemRef(new QName(id.getId()));
        Process p = this.newInstance(Process.class);
        p.setName("PROCESS");
        p.setId("processId");
        p.setProcessType(TProcessType.Public);
        def.addRootElement((RootElement)p);
        LaneSet laneSet = this.newInstance(LaneSet.class);
        p.addLaneSet(laneSet);
        Lane lane = this.newInstance(Lane.class);
        lane.setName("LANE");
        laneSet.addLane(lane);
        StartEvent se = this.newInstance(StartEvent.class);
        se.setId("startEventId");
        se.setName("START EVENT");
        se.addEventDefinition((EventDefinition)this.newInstance(MessageEventDefinition.class));
        p.addFlowElement((FlowElement)se);
        lane.addFlowNodeRef((FlowNode)se);
        EndEvent ee = this.newInstance(EndEvent.class);
        ee.setId("endEventId");
        ee.setName("END EVENT");
        lane.addFlowNodeRef((FlowNode)ee);
        p.addFlowElement((FlowElement)ee);
        ReceiveTask rt = this.newInstance(ReceiveTask.class);
        rt.setId("receiveTaskId");
        rt.setName("RECEIVE TASK");
        rt.setInstantiate(false);
        rt.setMessageRef(new QName(msg.getId()));
        lane.addFlowNodeRef((FlowNode)rt);
        p.addFlowElement((FlowElement)rt);
        DataInputAssociation dia = this.newInstance(DataInputAssociation.class);
        rt.addDataInputAssociation(dia);
        Assignment a = this.newInstance(Assignment.class);
        dia.addAssignment(a);
        Expression expTo = this.newInstance(Expression.class);
        expTo.setTextContent("expTo");
        a.setTo(expTo);
        Expression expFrom = this.newInstance(Expression.class);
        expFrom.setTextContent("expFrom");
        a.setFrom(expFrom);
        ParallelGateway pg = this.newInstance(ParallelGateway.class);
        pg.setId("pgId");
        pg.setName("PARALLEL GATEWAY");
        lane.addFlowNodeRef((FlowNode)pg);
        p.addFlowElement((FlowElement)pg);
        SequenceFlow sf1 = this.newInstance(SequenceFlow.class);
        sf1.setId("sf1Id");
        sf1.setName("SEQUENCE FLOW 1");
        sf1.setSourceRef((FlowNode)se);
        sf1.setTargetRef((FlowNode)rt);
        p.addFlowElement((FlowElement)sf1);
        SequenceFlow sf2 = this.newInstance(SequenceFlow.class);
        sf2.setId("sf2Id");
        sf2.setName("SEQUENCE FLOW 2");
        sf2.setSourceRef((FlowNode)rt);
        sf2.setTargetRef((FlowNode)pg);
        p.addFlowElement((FlowElement)sf2);
        SequenceFlow sf3 = this.newInstance(SequenceFlow.class);
        sf3.setId("sf3Id");
        sf3.setName("SEQUENCE FLOW 3");
        sf3.setSourceRef((FlowNode)pg);
        sf3.setTargetRef((FlowNode)ee);
        p.addFlowElement((FlowElement)sf3);
        Collaboration c = this.newInstance(Collaboration.class);
        def.addRootElement((RootElement)c);
        c.setName("COLLABORATION");
        Participant participant = this.newInstance(Participant.class);
        participant.setId("participantId");
        participant.setName("Participant");
        participant.addInterfaceRef(new QName(itf.getId()));
        participant.setProcessRef(new QName(p.getId()));
        c.addParticipant(participant);
        PartnerRole pr = this.newInstance(PartnerRole.class);
        def.addRootElement((RootElement)pr);
        pr.setName("PARTNER ROLE");
        pr.addParticipantRef(new QName(participant.getId()));
        MessageFlow mf = this.newInstance(MessageFlow.class);
        c.addMessageFlow(mf);
        mf.setMessageRef(new QName(msg.getId()));
        mf.setName("MESSAGE FLOW");
        mf.setSourceRef(new QName(ee.getId()));
        mf.setTargetRef(new QName(rt.getId()));
        return def;
    }

    private <T extends XmlObject> T newInstance(Class<? extends T> c) {
        if (this.context == null) {
            this.context = new XmlContextFactory().newContext();
        }
        return (T)((XmlObject)this.context.getXmlObjectFactory().create(c));
    }
}

