/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.bpmneditor.server.service.extension;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.mock.CompleteExampleGenerator;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.mock.PrivateProcessMockDB;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.DefinitionsHelper;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.foundation.BaseElementBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.infrastructure.DefinitionsBean;
import com.ebmwebsourcing.bpmneditor.server.service.bpmn2.clientToServer.ClientToServer;
import com.ebmwebsourcing.bpmneditor.server.service.bpmn2.serverToClient.ServerToClient;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectNode;
import com.ebmwebsourcing.easybox.api.XmlObjectXPathEvaluator;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.BaseElement;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.extension.client.AttributeExtension;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.junit.Test;

public class AttributeExtensionTest {
    private String testId1;
    private String testId2;
    private String testId3;

    @Test
    public void testDefinitionsAttibuteExtension() throws Exception {
        DefinitionsBean defsBefore = PrivateProcessMockDB.getProcess1();
        defsBefore.addAttributeExtension(new AttributeExtension("NS1", "LP1", "VAL1"));
        defsBefore.addAttributeExtension(new AttributeExtension("NS2", "LP2", "VAL2"));
        defsBefore.addAttributeExtension(new AttributeExtension("NS3", "LP3", "VAL3"));
        Definitions defs = ClientToServer.adapt((DefinitionsBean)defsBefore);
        Assert.assertNotNull((Object)defs.getOtherAttributes());
        Assert.assertEquals((int)3, (int)defs.getOtherAttributes().size());
        Assert.assertEquals((String)"VAL1", (String)defs.getOtherAttribute(new QName("NS1", "LP1")));
        Assert.assertEquals((String)"VAL2", (String)defs.getOtherAttribute(new QName("NS2", "LP2")));
        Assert.assertEquals((String)"VAL3", (String)defs.getOtherAttribute(new QName("NS3", "LP3")));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        defs.getXmlContext().createWriter().writeDocument((XmlObject)defs, (OutputStream)bos);
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toString().getBytes());
        defs = (Definitions)defs.getXmlContext().createReader().readDocument((InputStream)bis, Definitions.class);
        DefinitionsBean defsAfter = ServerToClient.adapt((Definitions)defs);
        Assert.assertNotNull((Object)defsAfter.getAttributeExtensions());
        Assert.assertEquals((int)3, (int)defsAfter.getAttributeExtensions().size());
        Assert.assertEquals((String)"VAL1", (String)defsAfter.getAttributeExtension("NS1", "LP1").getAttributeValue());
        Assert.assertEquals((String)"VAL2", (String)defsAfter.getAttributeExtension("NS2", "LP2").getAttributeValue());
        Assert.assertEquals((String)"VAL3", (String)defsAfter.getAttributeExtension("NS3", "LP3").getAttributeValue());
        try {
            defsAfter.addAttributeExtension(new AttributeExtension("NS2", "LP2", "VAL2bis"));
        }
        catch (IllegalArgumentException e) {
            return;
        }
        Assert.fail((String)"Should have thrown an exception.");
    }

    @Test
    public void testDefinitionsDuplicateAttibuteExtension() throws Exception {
        DefinitionsBean defsBefore = PrivateProcessMockDB.getProcess1();
        defsBefore.addAttributeExtension(new AttributeExtension("NS1", "LP1", "VAL1"));
        try {
            defsBefore.addAttributeExtension(new AttributeExtension("NS1", "LP1", "VAL1bis"));
        }
        catch (IllegalArgumentException e1) {
            Definitions defs = ClientToServer.adapt((DefinitionsBean)defsBefore);
            Assert.assertEquals((int)1, (int)defs.getOtherAttributes().size());
            Assert.assertEquals((String)"VAL1", (String)defs.getOtherAttribute(new QName("NS1", "LP1")));
            defs.addOtherAttribute(new QName("NS1", "LP1"), "VAL1ter");
            Assert.assertEquals((int)1, (int)defs.getOtherAttributes().size());
            Assert.assertEquals((String)"VAL1ter", (String)defs.getOtherAttribute(new QName("NS1", "LP1")));
            return;
        }
        Assert.fail((String)"Should have thrown an exception.");
    }

    @Test
    public void testBaseElementDuplicateAttributeExtensions() throws Exception {
        DefinitionsBean defsBefore = CompleteExampleGenerator.getExample();
        BaseElementBean b = DefinitionsHelper.getInstance().getElementById(defsBefore, CompleteExampleGenerator.UPPER_LANE_ID);
        AttributeExtension att1 = new AttributeExtension("NS", "LP", "VAL1");
        b.addAttributeExtension(att1);
        try {
            AttributeExtension att2 = new AttributeExtension("NS", "LP", "VAL1");
            b.addAttributeExtension(att2);
        }
        catch (IllegalArgumentException e) {
            Definitions defs = ClientToServer.adapt((DefinitionsBean)defsBefore);
            XmlObjectXPathEvaluator xpathEvaluator = defs.getXmlContext().createXPathEvaluator();
            XmlObjectNode xmlObjectNode1 = xpathEvaluator.selectSingleXmlObjectNode((XmlObject)defs, "//*[@id='" + b.getId() + "']", XmlObjectNode.class);
            BaseElement b1 = (BaseElement)xmlObjectNode1;
            Assert.assertEquals((int)1, (int)b1.getOtherAttributes().size());
            Assert.assertEquals((String)"VAL1", (String)b1.getOtherAttribute(new QName("NS", "LP")));
            b1.addOtherAttribute(new QName("NS", "LP"), "VAL1ter");
            Assert.assertEquals((int)1, (int)b1.getOtherAttributes().size());
            Assert.assertEquals((String)"VAL1ter", (String)b1.getOtherAttribute(new QName("NS", "LP")));
            return;
        }
        Assert.fail((String)"Should have thrown an exception.");
    }

    @Test
    public void testBaseElementAttributeExtension() throws Exception {
        DefinitionsBean defsBefore = this.getDefinitionsWithAttributeExtensions();
        Definitions defs = ClientToServer.adapt((DefinitionsBean)defsBefore);
        XmlObjectXPathEvaluator xpathEvaluator = defs.getXmlContext().createXPathEvaluator();
        XmlObjectNode xmlObjectNode1 = xpathEvaluator.selectSingleXmlObjectNode((XmlObject)defs, "//*[@id='" + this.testId1 + "']", XmlObjectNode.class);
        BaseElement b1 = (BaseElement)xmlObjectNode1;
        Assert.assertNotNull((Object)b1);
        Assert.assertNotNull((Object)b1.getOtherAttributes());
        Assert.assertEquals((int)1, (int)b1.getOtherAttributes().size());
        Assert.assertEquals((String)"VAL1", (String)b1.getOtherAttribute(new QName("NS1", "LP1")));
        XmlObjectNode xmlObjectNode2 = xpathEvaluator.selectSingleXmlObjectNode((XmlObject)defs, "//*[@id='" + this.testId2 + "']", XmlObjectNode.class);
        BaseElement b2 = (BaseElement)xmlObjectNode2;
        Assert.assertNotNull((Object)b2);
        Assert.assertNotNull((Object)b2.getOtherAttributes());
        Assert.assertEquals((int)1, (int)b2.getOtherAttributes().size());
        Assert.assertEquals((String)"VAL2", (String)b2.getOtherAttribute(new QName("NS2", "LP2")));
        XmlObjectNode xmlObjectNode3 = xpathEvaluator.selectSingleXmlObjectNode((XmlObject)defs, "//*[@id='" + this.testId3 + "']", XmlObjectNode.class);
        BaseElement b3 = (BaseElement)xmlObjectNode3;
        Assert.assertNotNull((Object)b3);
        Assert.assertNotNull((Object)b3.getOtherAttributes());
        Assert.assertEquals((int)2, (int)b3.getOtherAttributes().size());
        Assert.assertEquals((String)"VAL3", (String)b3.getOtherAttribute(new QName("NS3", "LP3")));
        Assert.assertEquals((String)"VAL4", (String)b3.getOtherAttribute(new QName("NS4", "LP4")));
        DefinitionsBean defsAfter = ServerToClient.adapt((Definitions)defs);
        b1 = DefinitionsHelper.getInstance().getElementById(defsAfter, this.testId1);
        Assert.assertNotNull((Object)b1.getAttributeExtensions());
        Assert.assertEquals((int)1, (int)b1.getAttributeExtensions().size());
        Assert.assertEquals((String)"VAL1", (String)b1.getAttributeExtension("NS1", "LP1").getAttributeValue());
        BaseElementBean b22 = DefinitionsHelper.getInstance().getElementById(defsAfter, this.testId2);
        Assert.assertNotNull((Object)b22.getAttributeExtensions());
        Assert.assertEquals((int)1, (int)b22.getAttributeExtensions().size());
        Assert.assertEquals((String)"VAL2", (String)b22.getAttributeExtension("NS2", "LP2").getAttributeValue());
        BaseElementBean b32 = DefinitionsHelper.getInstance().getElementById(defsAfter, this.testId3);
        Assert.assertNotNull((Object)b32.getAttributeExtensions());
        Assert.assertEquals((int)2, (int)b32.getAttributeExtensions().size());
        Assert.assertEquals((String)"VAL3", (String)b32.getAttributeExtension("NS3", "LP3").getAttributeValue());
        Assert.assertEquals((String)"VAL4", (String)b32.getAttributeExtension("NS4", "LP4").getAttributeValue());
    }

    private DefinitionsBean getDefinitionsWithAttributeExtensions() {
        DefinitionsBean defs = CompleteExampleGenerator.getExample();
        this.testId1 = CompleteExampleGenerator.COLLABORATION_ID;
        BaseElementBean b1 = DefinitionsHelper.getInstance().getElementById(defs, this.testId1);
        AttributeExtension att1 = new AttributeExtension("NS1", "LP1", "VAL1");
        b1.addAttributeExtension(att1);
        this.testId2 = CompleteExampleGenerator.LOWER_LANE_EL_3_ID;
        BaseElementBean b2 = DefinitionsHelper.getInstance().getElementById(defs, this.testId2);
        AttributeExtension att2 = new AttributeExtension("NS2", "LP2", "VAL2");
        b2.addAttributeExtension(att2);
        this.testId3 = CompleteExampleGenerator.UPPER_LANE_SF_4_ID;
        BaseElementBean b3 = DefinitionsHelper.getInstance().getElementById(defs, this.testId3);
        AttributeExtension att3 = new AttributeExtension("NS3", "LP3", "VAL3");
        b3.addAttributeExtension(att3);
        AttributeExtension att4 = new AttributeExtension("NS4", "LP4", "VAL4");
        b3.addAttributeExtension(att4);
        return defs;
    }
}

