/**
 * diagram-interchange - Diagram Interchange Domain - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.detachable.IDetachable;
import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * Diagram is a container of a graph of diagram elements depicting all or part
 * of a model.
 * 
 * @author nfleury
 * 
 */
public interface IDiagram extends IsSerializable, IDetachable {

	String getId();

	void setId(String id);

	String getName();

	void setName(String n);

	String getDocument();

	void setDocument(String d);

	double getResolution();

	void setResolution(double r);

	IDiagramElement getRootElement();
	
	void setRootElement(IDiagramElement rootElt);

	HashSet<IStyle> getStyles();
	
	void setStyles(HashSet<IStyle> styles);
	
	void addStyle(IStyle s);
	
	void removeStyle(IStyle s);

	void addDiagramElement(IDiagramElement diagramElement);

}
