/**
 * diagram-interchange - Diagram Interchange Domain - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.impl;

import java.util.LinkedHashSet;

import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.ILabel;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.ILabeledShape;

public abstract class LabeledShape extends Shape implements ILabeledShape{
	
	private LinkedHashSet<ILabel> ownedLabels;
	
	public LabeledShape() {
		super();
		this.ownedLabels = new LinkedHashSet<ILabel>();
	}
	
	@Override
	public LinkedHashSet<ILabel> getOwnedLabels() {
		return ownedLabels;
	}

	@Override
	public void setOwnedLabels(LinkedHashSet<ILabel> ownedLabels) {
		this.ownedLabels = ownedLabels;
	}
	
	@Override
	public void addOwnedLabel(ILabel label) {
		this.ownedLabels.add(label);
	}
	
	@Override
	public void removeOwnedLabel(ILabel label) {
		this.ownedLabels.remove(label);
	}
	
}
