/**
 * geasy-diagram-editor - A project for editing diagrams based on OMG Diagram Definition standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.geasytools.diagrameditor;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementGraphicState;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementView;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.observable.event.IMethodCalledEvent;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.observable.event.IObservableHandler;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.observable.event.ISetterCalledEvent;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.reflection.IHasReflectionHandler;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.reflection.event.IFieldValueChangedEvent;

public class DiagramElementGraphicalStateHandler implements IObservableHandler,IHasReflectionHandler{
	
	private IDiagramElementView elView;
	
	public DiagramElementGraphicalStateHandler(IDiagramElementView elView) {
		
		this.elView = elView;

	}
	
	@Override
	public void onMethodCalled(IMethodCalledEvent event) {
	
		
	}

	@Override
	public void onSetterCalled(ISetterCalledEvent event) {
		
		HashSet<IDiagramElementGraphicState> states = elView.getStates();
		
		for(IDiagramElementGraphicState gst:states){
			
			if (gst.condition(elView.getDiagramElement(), elView.getEditorModel())){
				gst.changeGraphicState(elView);
			}
		
		}
		
		
	}

	@Override
	public void onFieldValueChanged(IFieldValueChangedEvent event) {

		HashSet<IDiagramElementGraphicState> states = elView.getStates();
		
		for(IDiagramElementGraphicState gst:states){
			
			if (gst.condition(elView.getDiagramElement(), elView.getEditorModel())){
				gst.changeGraphicState(elView);
			}
		
		}

		
	}

}
