/**
 * geasy-diagram-editor - A project for editing diagrams based on OMG Diagram Definition standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.diagrameditor;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementGraphicState;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementView;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IContainer;
import com.ebmwebsourcing.geasytools.geasyui.api.core.events.IAddUIElementEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.core.events.IContainerHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.INewUIElementEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IRemoveUIElementEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IResizeRequestEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.ISelectedElementsEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IUIPanelHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IUnselectedElementsEvent;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.observable.IObservableProxy;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.observable.event.IObservableHandler;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.reflection.IHasReflectionHandler;

public class DiagramElementViewStateHandler {
	
	private DiagramController controller;
	
	public DiagramElementViewStateHandler(DiagramController controller){
		
		this.controller = controller;
		
		addHandlers();
	}
	
	private void addHandlers(){
		
		this.controller.getDiagramView().addUIPanelHandler(new IUIPanelHandler() {
			
			@Override
			public void onUnSelectUIElement(
					IUnselectedElementsEvent unselectedElementsEvent) {

				
			}
			
			@Override
			public void onSelectUIElement(ISelectedElementsEvent selectedElementsEvent) {

				
			}
			
			@Override
			public void onResizeRequest(IResizeRequestEvent event) {

				
			}
			
			@Override
			public void onRemoveUIElement(IRemoveUIElementEvent removeElementEvent) {

				
			}
			
			@Override
			public void onNewUIElement(INewUIElementEvent newElementEvent) {
				
				if (newElementEvent.getNewElement() instanceof IContainer){
					
					IContainer container = (IContainer) newElementEvent.getNewElement();
					
					container.addContainerHandler(new IContainerHandler() {
						
						@Override
						public void onRemoveUIElement(
								com.ebmwebsourcing.geasytools.geasyui.api.core.events.IRemoveUIElementEvent event) {
							
						}
						
						@Override
						public void onAddUIElement(IAddUIElementEvent event) {
							
							IDiagramElementView elView = (IDiagramElementView) event.getUIElement();
							
							for(IDiagramElementGraphicState state:elView.getStates()){
								
								if (state.condition(elView.getDiagramElement(), elView.getEditorModel())){
									
									state.changeGraphicState(elView);
									
								}
								
							}
							
						}
					});
					
				}
				
			}
		});
		
	}
	
	/**
	 * Listen to diagram element graphic. When its editor model changes
	 * it fires every state that condition is true. 
	 * @param elView
	 */
	public void listen(final IDiagramElementView elView){
		
		//bind for the initial state
		HashSet<IDiagramElementGraphicState> states = elView.getStates();
		for(IDiagramElementGraphicState gs:states){
			
			if (gs.condition(elView.getDiagramElement(), elView.getEditorModel())){
				gs.changeGraphicState(elView);
			}
			
			
		}		
		
		
		IObservableProxy observableProxy = (IObservableProxy) elView.getEditorModel();
		
		observableProxy.addHandler((IObservableHandler)new DiagramElementGraphicalStateHandler(elView));
		
		observableProxy.addHandler((IHasReflectionHandler)new DiagramElementGraphicalStateHandler(elView));
		
		

		
		
	}
	
	
	
	
}
