/**
 * geasy-diagram-editor - A project for editing diagrams based on OMG Diagram Definition standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.geasytools.diagrameditor.impl.graphic;

import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDefaultDiagramElementViewFactory;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementView;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramView;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IDiagramElement;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElement;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IHasDragProxy;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;

public class DefaultDiagramElementViewFactory implements IDefaultDiagramElementViewFactory{
	
	private IDiagramView diagramView;
	
	public DefaultDiagramElementViewFactory(IDiagramView diagramView) {
		this.diagramView = diagramView;
	}
	
	@Override
	public IDiagramElementView getElementByDiagramElementModel(
			IDiagramElement diagramElement) {
		
		return DiagramElementViewInstantiationHandlerRegistry.getInstance().getElementByDiagramElementModel(diagramElement,(IDiagramView) getUIPanel());
	}

	@Override
	public IUIElement getElement(IHasDragProxy draggableProxyData) {

		return DiagramElementViewInstantiationHandlerRegistry.getInstance().getElement(draggableProxyData,(IDiagramView) getUIPanel());
	}

	@Override
	public IUIElement getElement(Class<? extends IUIElement> elementType) {

		return DiagramElementViewInstantiationHandlerRegistry.getInstance().getElement(elementType,(IDiagramView) getUIPanel());
	}

	@Override
	public IUIPanel getUIPanel() {
		return diagramView;
	}

}
