/**
 * geasy-diagram-editor - A project for editing diagrams based on OMG Diagram Definition standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.diagrameditor.impl.validation;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.diagrameditor.IDiagramController;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IConformityRule;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IRuleNotificationRegistry;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.events.validation.RuleResolvedEvent;

public class RuleNotificationRegistry implements IRuleNotificationRegistry{

	private HashSet<IConformityRule> rulesInFailure;
	private HashSet<IConformityRule> rulesInWarning;
	private HashSet<IConformityRule> resolvedRules;
	
	private IDiagramController controller;
	
	public RuleNotificationRegistry(IDiagramController controller) {
		this.rulesInFailure = new HashSet<IConformityRule>();
		this.rulesInWarning = new HashSet<IConformityRule>();
		this.resolvedRules  = new HashSet<IConformityRule>(); 
		this.controller = controller;
	}
	
	@Override
	public IDiagramController getController() {
		return controller;
	}
	
	@Override
	public void setRulesInFailure(HashSet<IConformityRule> rules) {
		//compare passed rules with last to grab the one that was resolved 
		//in theory we shouldnt have more than 1 resolved rules at a time
		this.rulesInFailure.removeAll(rules);
		
		if (rulesInFailure.size()==1 && rulesInFailure.iterator().hasNext()){
			IConformityRule resolvedRule = rulesInFailure.iterator().next();
		
			controller.fireEvent(new RuleResolvedEvent(resolvedRule));
		}
		
		this.rulesInFailure = rules;
		if (controller.getRuleNotificationView()!=null) controller.getRuleNotificationView().refresh();
	}
	
	@Override
	public void setRulesInWarning(HashSet<IConformityRule> rules) {
		this.rulesInWarning.removeAll(rules);
		
		if (rulesInWarning.size()==1 && rulesInWarning.iterator().hasNext()){
			IConformityRule resolvedRule = rulesInWarning.iterator().next();
		
			controller.fireEvent(new RuleResolvedEvent(resolvedRule));
		}
		
		this.rulesInWarning = rules;
		if (controller.getRuleNotificationView()!=null) controller.getRuleNotificationView().refresh();
	}
	
	@Override
	public HashSet<IConformityRule> getRulesInFailure() {
		return rulesInFailure;
	}

	@Override
	public HashSet<IConformityRule> getRulesInWarning() {
		return rulesInWarning;
	}

	@Override
	public HashSet<IConformityRule> getResolvedRules() {
		return resolvedRules;
	}

	@Override
	public void addResolvedRule(IConformityRule rule) {
		this.resolvedRules.add(rule);
	}



}
