/**
 * geasy-graph - A project to deal with graph problematics: pathfinding etc... - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasygraph.impl;

import java.util.HashSet;
import java.util.Iterator;

import com.ebmwebsourcing.geasytools.geasygraph.api.IGraph;
import com.ebmwebsourcing.geasytools.geasygraph.api.INode;

public class Graph implements IGraph{

	private HashSet<INode> nodes;
	
	public Graph() {
		this.nodes = new HashSet<INode>();
	}
	
	@Override
	public void addNode(INode node) {
		this.nodes.add(node);
	}

	@Override
	public HashSet<INode> getNodes() {
		return nodes;
	}
	
	public Node getNodeById(String id){
		
		Iterator<INode> it = nodes.iterator();
		
		while(it.hasNext()){
			
			Node n = (Node) it.next(); 
			
			if (n.getId().equals(id)){
				return n;
			}
			
		}
		
		return null;
	}

}
