/**
 * geasy-widgets - Some useful widgets - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.widgets.core.impl.input;

import java.util.HashMap;
import java.util.LinkedHashMap;

import com.ebmwebsourcing.geasytools.widgets.core.api.input.IComboBox;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Composite;

public abstract class AbstractComboBox<T> extends Composite implements IComboBox<T>{
	
	private LinkedHashMap<String, T> items;
	
	public AbstractComboBox() {
		
		this.items = new LinkedHashMap<String, T>();
		
	}
	
	@Override
	public void addItem(T item) {
		this.items.put(item.toString(), item);
		
	}

	@Override
	public void addItem(T value, String label) {
		this.items.put(label, value);
		
	}

	@Override
	public void clear() {
		this.items.clear();
		
	}

	@Override
	public HashMap<String, T> getItems() {
		return items;
	}



	@Override
	public HandlerRegistration addValueChangeHandler(
			ValueChangeHandler<T> handler) {
		return addHandler(handler, ValueChangeEvent.getType());
	}



}
