/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.test;

import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.test.DummyModel;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.IHasEditorProxy;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.test.DataProvider;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.test.HasModelEditor;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.test.HasModelEditorExtension;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.test.SampleEditor;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.test.SampleEditorExtension;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.test.SpecializedTemplate;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.uifield.ListUIField;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.uifield.TextBoxUIField;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.uifield.events.DisplayEvent;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.junit.client.GWTTestCase;

public class UIBinderTestGwt
extends GWTTestCase {
    protected void gwtSetUp() throws Exception {
        super.gwtSetUp();
    }

    public String getModuleName() {
        return "com.ebmwebsourcing.geasytools.modeleditor.modelmanager.ModelManager";
    }

    public void testSimpleUIBinding() {
        DummyModel model = (DummyModel)GWT.create(DummyModel.class);
        IHasEditorProxy proxy = (IHasEditorProxy)model;
        SpecializedTemplate form = (SpecializedTemplate)proxy.getEditor(null);
        TextBoxUIField textBox = (TextBoxUIField)form.getVerticalPanel().getWidget(0);
        System.out.println("Model initial value:" + model.getString1());
        System.out.println("textBoxValue: " + (String)textBox.getValue());
        UIBinderTestGwt.assertEquals((String)model.getString1(), (String)((String)textBox.getValue()));
        System.out.println("Changing model 1 string1 to: hello");
        model.setString1("hello");
        System.out.println("textBoxValue: " + (String)textBox.getValue());
        UIBinderTestGwt.assertEquals((String)model.getString1(), (String)((String)textBox.getValue()));
        System.out.println("Changing textBox value to: goodbye");
        ValueChangeEvent.fire((HasValueChangeHandlers)textBox, (Object)"goodbye");
        textBox.setValue((Object)"goodbye", true);
        System.out.println("textBox value:" + (String)textBox.getValue());
        System.out.println("model string1 value:" + model.getString1());
        UIBinderTestGwt.assertEquals((String)((String)textBox.getValue()), (String)model.getString1());
    }

    public void testEditorGenerator() {
        String p1Value = "p1Value";
        HasModelEditor model = (HasModelEditor)GWT.create(HasModelEditor.class);
        model.setProperty1(p1Value);
        IHasEditorProxy proxy = (IHasEditorProxy)model;
        DataProvider dataProvider = new DataProvider();
        dataProvider.addStringData("string1");
        dataProvider.addStringData("string2");
        dataProvider.addStringData("string3");
        SampleEditor template = (SampleEditor)proxy.getEditor((Object)dataProvider);
        UIBinderTestGwt.assertTrue((template != null ? 1 : 0) != 0);
        TextBoxUIField<String> w1 = template.getW1();
        ListUIField<String> w2 = template.getW2();
        w1.fireEvent((GwtEvent)new DisplayEvent());
        w2.fireEvent((GwtEvent)new DisplayEvent());
        UIBinderTestGwt.assertTrue((w1 != null ? 1 : 0) != 0);
        UIBinderTestGwt.assertEquals((String)p1Value, (String)((String)w1.getValue()));
        UIBinderTestGwt.assertTrue((w2 != null ? 1 : 0) != 0);
        UIBinderTestGwt.assertTrue((w2.getOptions().size() == 3 ? 1 : 0) != 0);
        UIBinderTestGwt.assertTrue((boolean)w2.getOptions().containsAll(dataProvider.getStringData()));
        System.out.println("Editor==>" + (Object)((Object)template));
    }

    public void testEditorCache() {
        HasModelEditorExtension model = (HasModelEditorExtension)GWT.create(HasModelEditorExtension.class);
        IHasEditorProxy proxy = (IHasEditorProxy)model;
        DataProvider dataProvider = new DataProvider();
        dataProvider.addStringData("string1");
        dataProvider.addStringData("string2");
        dataProvider.addStringData("string3");
        SampleEditorExtension template = (SampleEditorExtension)proxy.getEditor((Object)dataProvider);
        TextBoxUIField<String> w1 = template.getW1();
        ListUIField<String> w2 = template.getW2();
        TextBoxUIField<String> w3 = template.getW3();
        SampleEditorExtension template2 = (SampleEditorExtension)proxy.getEditor((Object)dataProvider);
        UIBinderTestGwt.assertEquals(w1, template2.getW1());
        UIBinderTestGwt.assertEquals(w2, template2.getW2());
        UIBinderTestGwt.assertEquals(w3, template2.getW3());
    }

    public void testEditorGeneratorWithInheritance() {
        String p3Value = "p3Value";
        String p1Value = "p1Value";
        HasModelEditorExtension model = (HasModelEditorExtension)GWT.create(HasModelEditorExtension.class);
        model.setProperty3(p3Value);
        model.setProperty1(p1Value);
        IHasEditorProxy proxy = (IHasEditorProxy)model;
        DataProvider dataProvider = new DataProvider();
        dataProvider.addStringData("string1");
        dataProvider.addStringData("string2");
        dataProvider.addStringData("string3");
        SampleEditorExtension template = (SampleEditorExtension)proxy.getEditor((Object)dataProvider);
        TextBoxUIField<String> w1 = template.getW1();
        ListUIField<String> w2 = template.getW2();
        TextBoxUIField<String> w3 = template.getW3();
        w1.fireEvent((GwtEvent)new DisplayEvent());
        w2.fireEvent((GwtEvent)new DisplayEvent());
        w3.fireEvent((GwtEvent)new DisplayEvent());
        UIBinderTestGwt.assertTrue((template != null ? 1 : 0) != 0);
        UIBinderTestGwt.assertTrue((w1 != null ? 1 : 0) != 0);
        UIBinderTestGwt.assertEquals((String)p1Value, (String)((String)w1.getValue()));
        UIBinderTestGwt.assertTrue((w2 != null ? 1 : 0) != 0);
        UIBinderTestGwt.assertTrue((w2.getOptions().size() == 3 ? 1 : 0) != 0);
        UIBinderTestGwt.assertTrue((boolean)w2.getOptions().containsAll(dataProvider.getStringData()));
        UIBinderTestGwt.assertEquals((String)p3Value, (String)((String)w3.getValue()));
        System.out.println("Editor==>" + (Object)((Object)template));
    }
}

