/**
 * model-manager - Handles models on client side for stuffs like undo/redo, methods observers, uibinding ... - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.lookup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class HasLookupProxyImpl implements IHasLookupProxy{
	
	private HashMap<Class<?>, Object> objectByType; 
	private HashMap<Class<?>,List<Object>> objectsByType;
	
	public HasLookupProxyImpl() {
		
		this.objectByType 	= new HashMap<Class<?>, Object>();
		this.objectsByType 	= new HashMap<Class<?>, List<Object>>();
		
	}
	
	@Override
	public Object lookup(Class<?> type) {
		return objectByType.get(type);
	}

	@Override
	public List<Object> lookupAll(Class<?> type) {
		return (List<Object>) objectsByType.get(type);
	}

	@Override
	public void register(Object object) {
		this.objectByType.put(object.getClass(), object);
		//also register object for all super class of current class
		for(Class<?> c:getAllSuperClasses(object.getClass())){
			this.objectByType.put(c, object);
		}
	}

	@Override
	public void register(Object... objects) {
		
		ArrayList<Object> oList = new ArrayList<Object>();
		
		for(Object o : objects){oList.add(o);}
		
		this.objectsByType.put(objects[0].getClass(), oList);
		
	}
	
	private Set<Class<?>> getAllSuperClasses(Class<?> clazz){
		
		HashSet<Class<?>> result = new HashSet<Class<?>>();
		
		Class<?> current = clazz;
		 
		while(current.getSuperclass()!=Object.class){
			
			result.add(current.getSuperclass());
			
			current = current.getSuperclass();
		}
		
		return result;
	}
	
}
