/**
 * model-manager - Handles models on client side for stuffs like undo/redo, methods observers, uibinding ... - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

import org.apache.commons.lang.ClassUtils;

public class ClassTypeHelper {

	private  Class<?> clazz;
	
	public ClassTypeHelper(Class<?> clazz) {
		this.clazz = clazz;
	}
	

	public Set<Field> getAllFields(){
		LinkedHashSet<Field> fields = new LinkedHashSet<Field>();
		
		Class<?> currentType = clazz;
		while(currentType.getSuperclass()!=null){
			for(Field field:currentType.getFields()){
				if (fieldsContain(field, fields)==false) fields.add(field);
			}
			currentType = currentType.getSuperclass();
		}
		
		return fields;
	}
	
	
	private  boolean fieldsContain(Field field,Set<Field> fields){
		for(Field f:fields){
			if (field.getName().equals(f.getName())){
				return true;
			}
		}
		return false;
	}
	
	
	public static boolean isOfSameNumberType(Class<?> clazz,Class<?> fieldType){
		if (isNumberType(clazz) && isNumberType(fieldType)){
			if (ClassUtils.wrapperToPrimitive(clazz)!=null){
				clazz = ClassUtils.wrapperToPrimitive(clazz);
			}
			if (ClassUtils.wrapperToPrimitive(fieldType)!=null){
				fieldType = ClassUtils.wrapperToPrimitive(fieldType); 
			}
			if (clazz==fieldType){
				return true;
			}
		}
		return false;
	}


	public static boolean isPrimitive(Class<?> clazz){
		boolean isPrimitiveOrWrapped = clazz.isPrimitive() || ClassUtils.wrapperToPrimitive(clazz) != null;
		return isPrimitiveOrWrapped;
	}


	private static boolean isNumberType(Class<?> type){
		return Number.class.isAssignableFrom(type);
	}

	
	
	public static String getCollectionSubTypeName(Class<?> clazz) {
		if(clazz.isInterface()) {
			if(List.class.isAssignableFrom(clazz)) {
				return ArrayList.class.getCanonicalName();
			}
			else if(Set.class.isAssignableFrom(clazz)) {
				return HashSet.class.getCanonicalName();
			}
			else {
				throw new IllegalArgumentException();
			}
		}
		else {
			return clazz.getCanonicalName();
		}
	}
	
}
