/**
 * model-manager - Handles models on client side for stuffs like undo/redo, methods observers, uibinding ... - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;

import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.user.rebind.ClassSourceFileComposerFactory;
import com.google.gwt.user.rebind.SourceWriter;

public class ComposerHelper {
	
	private ClassSourceFileComposerFactory composer;
	private PrintWriter printWriter;
	private GeneratorContext context;
	private SourceWriter writer;
	private TreeLogger logger;
	
	private String packageName;
	private String simpleClassName;
	
	private Set<Clazz> innerClasses;
	private Set<Method> methods;
	private Set<Class<?>> imports;
	private Set<Field> fields;
	
	public ComposerHelper(GeneratorContext context,TreeLogger logger,String packageName,String simpleClassName) {
		
		this.composer = new ClassSourceFileComposerFactory(packageName, simpleClassName);
		this.context  = context;
		this.logger   = logger;
		
		this.packageName 		= packageName;
		this.simpleClassName 	= simpleClassName;
		
		this.methods  = new LinkedHashSet<Method>();
		this.imports  = new LinkedHashSet<Class<?>>();
		this.fields   = new LinkedHashSet<Field>();
		this.innerClasses = new LinkedHashSet<Clazz>();

	}
	
	public String getCreatedClassName(){
		return composer.getCreatedClassName();
	}
	
	
	public void addImport(Class<?> imp0rt){
		this.composer.addImport(imp0rt.getCanonicalName());
	}
	
	public void setSuperClass(String superClassName){
		this.composer.setSuperclass(superClassName);
	}
	
	public void setSuperClass(Class<?> superClass){
		this.composer.setSuperclass(superClass.getCanonicalName());
	}
	
	public void addInterface(Class<?> int3rface){
		this.composer.addImplementedInterface(int3rface.getCanonicalName());
	}
	
	
	private void write(String content){
		
		if (printWriter==null && writer==null){
			this.printWriter = context.tryCreate(logger, packageName, simpleClassName);
			if (this.printWriter!=null) this.writer 	 = composer.createSourceWriter(context,printWriter);			
			if (this.printWriter!=null) this.writer.indent();
		}
		
		if (this.printWriter!=null) this.writer.println(content);

	}
	

	
	public void addMethod(Method method,Class<?> ...imports){
		
		this.methods.add(method);
		
		this.imports.addAll(Arrays.asList(imports));
		
	}
	
	public void addInnerClass(Clazz clazz){
		this.innerClasses.add(clazz);
	}
	
	public void addField(Field field){
		this.fields.add(field);	
	}
	
	public void commit(){
		
		//add all imports first
		for(Class<?> imp0rt:imports){
			
			this.addImport(imp0rt);
			
		}
		
		write("\n");
		
		//add all fields
		for(Field field:fields){
			
			write(field.toString());
			
		}
		
		//add all methods		
		for(Method method : methods){
			
			write(method.toString());			
			write("\n");
		}
		
		
		//add all inner classes
		for(Clazz clazz: innerClasses){
			
			write(clazz.toString());
			
		}
		
		
		if (this.printWriter!=null) writer.commit(logger);
		
	}

	public void addInterface(String typeName) {
		this.composer.addImplementedInterface(typeName);
	}

	

	
	
	
	
	

	
	
}
