/**
 * model-manager - Handles models on client side for stuffs like undo/redo, methods observers, uibinding ... - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper;

import com.google.gwt.core.ext.typeinfo.JPrimitiveType;
import com.google.gwt.core.ext.typeinfo.JType;

public class JTypeHelper {

	public JTypeHelper() {
	
	}
	
	public static Class<?> getClass(JType type){

		if (type.isPrimitive()==null){
			try {
				return Class.forName(type.getQualifiedBinaryName());
			} catch (ClassNotFoundException e) {
				e.printStackTrace();
			}
		}else{
			
			try {
				return Class.forName(type.isPrimitive().getQualifiedBoxedSourceName());
			} catch (ClassNotFoundException e) {
				e.printStackTrace();
			}
			
		}
		
		return null;
	}
	
	public static boolean isNumberJtype(JPrimitiveType type) {
		return type==JPrimitiveType.DOUBLE
				|| type==JPrimitiveType.FLOAT
				|| type==JPrimitiveType.INT
				|| type==JPrimitiveType.LONG
				|| type==JPrimitiveType.SHORT;
	}
	
}
