/**
 * model-manager - Handles models on client side for stuffs like undo/redo, methods observers, uibinding ... - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.modelbinder;

import org.apache.commons.lang.IllegalClassException;

import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelbinder.annotation.BindedModelProxy;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.ClassTypeHelper;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.ComposerHelper;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.Field;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.JClassTypeHelper;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.JTypeHelper;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.Method;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.Visibility;
import com.google.gwt.core.ext.Generator;
import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JField;
import com.google.gwt.core.ext.typeinfo.NotFoundException;

public class BindedModelProxyGenerator extends Generator{

	private ComposerHelper composerHelper;

	private BindedModelProxy bindedModelProxyAnnotation;
	private String className;
	private JClassType bindedModelType;
	private Field bindedModelField;


	@Override
	public String generate(TreeLogger logger, GeneratorContext context,
			String typeName) throws UnableToCompleteException {
		try {
			JClassType type 				= context.getTypeOracle().getType(typeName);

			this.className					= type.getSimpleSourceName()+"_BindedModelProxy"; 

			this.composerHelper 			= new ComposerHelper(context, logger, type.getPackage().getName(), className);

			this.composerHelper.addInterface(typeName);


			this.bindedModelProxyAnnotation = type.getAnnotation(BindedModelProxy.class);

			if (bindedModelProxyAnnotation==null){
				throw new IllegalClassException(type.getQualifiedSourceName()+" must be annotated with "+BindedModelProxy.class);
			}

			bindedModelType					= context.getTypeOracle().getType(bindedModelProxyAnnotation.type().getCanonicalName());

			createBindedModelField();			
			createGetBindedModelMethod();
			createSetBindedModelMethod();

			createSetFieldValue(Object.class);
			createSetFieldValue(Integer.class);
			createSetFieldValue(Long.class);
			createSetFieldValue(Float.class);
			createSetFieldValue(Double.class);
			createSetFieldValue(Boolean.class);

			composerHelper.commit();
		} catch (NotFoundException e) {
			e.printStackTrace();
			throw new UnableToCompleteException();
		}

		return this.composerHelper.getCreatedClassName();
	}


	private void createBindedModelField(){
		bindedModelField = new Field(Visibility.PRIVATE, JTypeHelper.getClass(bindedModelType), "bindedModel");
		this.composerHelper.addField(bindedModelField);
	}


	private void createSetBindedModelMethod(){
		Method m = new Method(Visibility.PUBLIC,void.class, "setBindedModel");
		m.addParameter(m.new Parameter(Object.class, "model"));
		m.getBody().append(String.format("this.bindedModel = (%s) model", bindedModelType.getQualifiedSourceName()));
		composerHelper.addMethod(m);
	}	


	private void createGetBindedModelMethod(){
		Method m = new Method(Visibility.PUBLIC,Object.class, "getBindedModel");
		m.getBody().append("return this.bindedModel");
		composerHelper.addMethod(m);
	}


	private void createSetFieldValue(Class<?> clazz){
		Method setFieldValueMethod = new Method(Visibility.PUBLIC,void.class, "setFieldValue");
		setFieldValueMethod.isOverride(true);
		setFieldValueMethod.addParameter(setFieldValueMethod.new Parameter(String.class, "name"));
		setFieldValueMethod.addParameter(setFieldValueMethod.new Parameter(clazz, "value"));

		JClassTypeHelper helper = new  JClassTypeHelper(bindedModelType);

		for(JField field:helper.getAllFields()) {
			if(ignoreField(field)) continue;
			
			Field tmpField = new Field(Visibility.PRIVATE,JTypeHelper.getClass(field.getType()),field.getName(),field.getType().isParameterized());
			Class<?> fieldType = JTypeHelper.getClass(field.getType());
			Method setter = tmpField.getSetter(false, false);

			if (ClassTypeHelper.isOfSameNumberType(clazz, fieldType)){
				setFieldValueMethod.getBody().append(String.format("if (name.equals(\"%s\")) bindedModel.%s((%s)value)", field.getName(),setter.getName(),field.getType().getQualifiedSourceName()));
			}else{
				if (fieldType==clazz){
					setFieldValueMethod.getBody().append(String.format("if (name.equals(\"%s\")) bindedModel.%s((%s)value)", field.getName(), setter.getName(),field.getType().getQualifiedSourceName()));
				}
				if (clazz==Object.class && ClassTypeHelper.isPrimitive(fieldType)==false){
					setFieldValueMethod.getBody().append(String.format("if (name.equals(\"%s\")) bindedModel.%s((%s)value)", field.getName(), setter.getName(),field.getType().getQualifiedSourceName()));						
				}
			}
		}

		composerHelper.addMethod(setFieldValueMethod);
	}

	
	private boolean ignoreField(JField field) {
		return field.isFinal();
	}
	
}
