/**
 * model-manager - Handles models on client side for stuffs like undo/redo, methods observers, uibinding ... - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.observable;

import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.observable.IObservableProxy;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.observable.annotation.Observable;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.observable.event.IObservableHandler;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.observable.event.MethodCalledEvent;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.observable.event.SetterCalledEvent;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.reflection.annotation.Reflection;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.ComposerHelper;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.Field;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.JClassTypeHelper;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.JTypeHelper;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.Method;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.Visibility;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.reflection.ReflectionProxyGenerator;
import com.google.gwt.core.ext.Generator;
import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JField;
import com.google.gwt.event.shared.GwtEvent;

public class ObservableProxyGenerator extends Generator{
	
	private JClassType type;
	private ComposerHelper composerHelper;
	private String simpleClassName;
	private Observable observalbeAnnotation;
	private Reflection reflectionAnnotation;
	
	
	@Override
	public String generate(TreeLogger logger, GeneratorContext context,
			String typeName) throws UnableToCompleteException {
		simpleClassName = type.getSimpleSourceName() + "_ObservableProxy";
		
		composerHelper	= new ComposerHelper(context, logger, type.getPackage().getName(), simpleClassName);
		
		composerHelper.setSuperClass(typeName);
		
		composerHelper.addInterface(IObservableProxy.class);
		
		observalbeAnnotation = type.getAnnotation(Observable.class);
		reflectionAnnotation = type.getAnnotation(Reflection.class);
		
		createConstructor();
		
		createAddHandlerMethod();
		
		createFireEventMethod();
		
		overrideAllSetters();
		
		composerHelper.commit();
		
		return composerHelper.getCreatedClassName();
	}
	
	
	private void createConstructor(){
		Method constructor = new Method(Visibility.PUBLIC,simpleClassName);
		
		//add handlers specified in annotation
		if (observalbeAnnotation!=null){
			for(Class<? extends IObservableHandler> clazz:observalbeAnnotation.handlers()){
				constructor.getBody().append(String.format("this.addHandler(new %s())", clazz.getCanonicalName()));
			}
		}
		
		composerHelper.addMethod(constructor);
	}

	
	private void createAddHandlerMethod(){
		Method addHandlerMethod = new Method(Visibility.PUBLIC,void.class,"addHandler");
		addHandlerMethod.isOverride(true);
		addHandlerMethod.addParameter(addHandlerMethod.new Parameter(IObservableHandler.class, "handler"));
		
		composerHelper.addImport(MethodCalledEvent.class);
		composerHelper.addImport(SetterCalledEvent.class);
		
		addHandlerMethod.getBody().append(ReflectionProxyGenerator.getHandlerManagerMethodName+".addHandler(MethodCalledEvent.TYPE,handler)");
		addHandlerMethod.getBody().append(ReflectionProxyGenerator.getHandlerManagerMethodName+".addHandler(SetterCalledEvent.TYPE,handler)");
		
		composerHelper.addMethod(addHandlerMethod);
	}
	
	
	private void overrideAllSetters(){
		JClassTypeHelper helper = new  JClassTypeHelper(type);
		
		for(JField field:helper.getAllFields()) {
			if(ignoreField(field)) continue;
			
			Field f = new Field(Visibility.PRIVATE,JTypeHelper.getClass(field.getType()),field.getName());
			f.setJtype(field.getType());
			
			Method setter = f.getSetter(true,true);
			
			composerHelper.addImport(com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.Field.class);
			
			setter.getBody().append(String.format("Field field = (Field) getFields().get(\"%s\")",f.getName()));
			setter.getBody().append("fireEvent(new SetterCalledEvent(\""+setter.getName()+"\",field))");
			
			composerHelper.addMethod(setter);
		}
	}
	
	
	private boolean ignoreField(JField field){
		if(field.isFinal()) {
			return true;
		}
		
		if (reflectionAnnotation!=null){
			for(String fieldName:reflectionAnnotation.skipFields()){
				if (fieldName.equals(field.getName())){
					return true;
				}
			}
		}
		return false;
	}
	
	
	private void createFireEventMethod() {
		Method fireEventMethod = new Method(Visibility.PUBLIC,void.class,"fireEvent");
		fireEventMethod.isOverride(true);
		fireEventMethod.addParameter(fireEventMethod.new Parameter(GwtEvent.class, "event"));
		
		fireEventMethod.getBody().append("this."+ReflectionProxyGenerator.getHandlerManagerMethodName+".fireEvent(event)");
		
		composerHelper.addMethod(fireEventMethod);
	}

	
	public void setType(JClassType type) {
		this.type = type;
	}
	
}
