/**
 * webeditor-file-repository - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasywebeditor.client.file.repository.service;

import java.util.List;
import java.util.Map;

import com.ebmwebsourcing.geasywebeditor.client.file.repository.to.SearchFormData;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstance;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceFormat;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceMetaData;
import com.ebmwebsourcing.webeditor.impl.domain.exception.ServiceException;
import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;

@RemoteServiceRelativePath("FileRepositoryService")
public interface FileRepositoryService extends RemoteService{

	/**
	 * Tests that the provided URL is functioning.
	 * Tests that the provided URL is a functioning file repository.
	 * @param repoRootUrl
	 * @param fileRepositoryInquiryServiceName the qualified name of the class that will be used as a String
	 * to contact the file repository
	 * @return true if the URL is a a functioning URL denoting a compliant file repository
	 * @throws ServiceException
	 */
	public boolean testURL(String repoRootUrl, String fileRepositoryInquiryServiceName) throws ServiceException; 
	
	/**
	 * Performs a search in the last valid file repository proposed by the user.
	 * @param data the data provided by the user
	 * @return a mapping <display name of the file, id of the file>. The key set will be displayed as reuslt of
	 * the search the values should be used to upload the wanted files
	 * @throws ServiceException
	 */
	public Map<String,String> searchFile(SearchFormData data) throws ServiceException;
	
	/**
	 * Uploads the files to the server from the last valid file repository provided by the user,
	 * and attaches it to the given ProjectInstance
	 * @param services a mapping <display name of the file, id of the file>. Names will be used as file names on the server
	 * and ids will be used to retrieve the files from the repository
	 * @param instance the project instance to which the files from the repository should be attached
	 * @param format the format of the attached files
	 * @return the meta data extracted from the files
	 * @throws ServiceException
	 */
	public List<IProjectInstanceMetaData> attachFilesFromRepoDescription(Map<String,String> files, IProjectInstance instance, IProjectInstanceFormat format) throws ServiceException;
}
