/**
 * webeditor-file-repository - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasywebeditor.client.file.repository.service;

import java.util.List;
import java.util.Map;

import com.ebmwebsourcing.geasywebeditor.client.file.repository.to.SearchFormData;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstance;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceFormat;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceMetaData;
import com.google.gwt.user.client.rpc.AsyncCallback;

public interface FileRepositoryServiceAsync {

    public void testURL(String repoRootUrl, String fileRepositoryInquiryServiceName,
            AsyncCallback<Boolean> callback);

    public void searchFile(SearchFormData data, AsyncCallback<Map<String, String>> callback);

    public void attachFilesFromRepoDescription(Map<String, String> files,
            IProjectInstance instance, IProjectInstanceFormat metaDataFormat,
            AsyncCallback<List<IProjectInstanceMetaData>> callback);

}
