/**
 * webeditor-file-repository - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.geasywebeditor.server.file.repository.url;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

import com.ebmwebsourcing.geasywebeditor.client.file.repository.exception.InvalidURLException;

/**
 * Helper class to test if an url is reachable
 * 
 * @author gcrosmarie
 *
 */
public class URLTester {

    public static void testURL(String url) throws InvalidURLException{
        try {
            URL u = new URL(url);
            testURL(u);
        } catch (MalformedURLException e) {
            e.printStackTrace();
            throw new InvalidURLException(url,e);
        }
    }
    
    public static void testURL(URL url) throws InvalidURLException {
        try {
            HttpURLConnection connexionHttp = (HttpURLConnection) url.openConnection(); 
            connexionHttp.connect(); 
            int code = connexionHttp.getResponseCode(); 
            if (code != 200) { 
                throw new InvalidURLException(url.toString(),"");
            } 
            connexionHttp.disconnect(); 
            InputStream inputStream = url.openStream(); 
            try { 
                inputStream.read(); 
            } finally { 
                inputStream.close(); 
            }
        }
        catch(IOException e) {
            e.printStackTrace();
            throw new InvalidURLException(url.toString(), e);
        }
    }
    
}
