/**
 * domain - Domain Implementation for WSDL Schema Definition Language - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasywsdl.domain;

import java.util.HashSet;
import java.util.Set;

import com.ebmwebsourcing.geasywsdl.domain.api.IBinding;
import com.ebmwebsourcing.geasywsdl.domain.api.IDefinitions;
import com.ebmwebsourcing.geasywsdl.domain.api.IPortType;
import com.ebmwebsourcing.geasywsdl.domain.api.IService;
import com.ebmwebsourcing.geasywsdl.domain.api.ITypes;

public class Definitions implements IDefinitions {
	
	private static final long serialVersionUID = 1887582859776751091L;
	
	private String tns = "";
	private Set<IDefinitions> imports = new HashSet<IDefinitions>();
	private ITypes types;
	private Set<IPortType> portTypes = new HashSet<IPortType>();
	private Set<IBinding> bindings = new HashSet<IBinding>();
	
	private Set<IService> services = new HashSet<IService>();
	
	public Definitions() {

	}
	
	@Override
	public String getTargetNamespace() {
		return tns;
	}

	@Override
	public void setTargetNamespace(String tns) {
		if(tns != null){
			this.tns = tns;
		} else {
			this.tns = "";
		}
	}
	
	@Override
	public Set<IDefinitions> getImports() {
		return imports;
	}

	@Override
	public void addImport(IDefinitions definitions) {
		imports.add(definitions);
	}

	@Override
	public void addPortType(IPortType portType) {
		this.portTypes.add(portType);
	}

	@Override
	public Set<IPortType> getPortTypes() {
		return portTypes;
	}

    @Override
    public ITypes getTypes() {
        return types;
    }

    @Override
    public void setTypes(ITypes types) {
        this.types = types;
    }

	@Override
	public Set<IBinding> getBindings() {
		return bindings;
	}

	@Override
	public void addBinding(IBinding binding) {
		bindings.add(binding);
	}

	@Override
	public Set<IService> getServices() {
		return services;
	}

	@Override
	public void addService(IService service) {
		services.add(service);
	}
	
	@Override
	public int hashCode(){
		return tns.hashCode();
	}

	@Override
	public boolean equals(Object o){
		if(o instanceof IDefinitions){
			return tns.equals(((IDefinitions) o).getTargetNamespace());
		} else {
			return false;
		}
	}
}
