/**
 * domain - Domain Implementation for WSDL Schema Definition Language - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasywsdl.domain;

import java.util.HashSet;
import java.util.Set;

import com.ebmwebsourcing.geasyschema.domain.api.ISchema;
import com.ebmwebsourcing.geasywsdl.domain.api.ITypes;

public class Types implements ITypes {

	private static final long serialVersionUID = -705849298730494451L;
	
	private Set<ISchema> schemas = new HashSet<ISchema>();
    
    public Types() {

    }

    @Override
    public void addSchema(ISchema schema) {
        schemas.add(schema);
    }

    @Override
    public Set<ISchema> getSchemas() {
        return schemas;
    }

    @Override
    public void removeSchema(ISchema schema) {
        schemas.remove(schema);
    }
    
    
    
}
