/**
 * geasywsdl-domain - Domain Implementation for WSDL Schema Definition Language - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasywsdl.domain;

import com.ebmwebsourcing.geasywsdl.domain.api.IBinding;
import com.ebmwebsourcing.geasywsdl.domain.api.IWsdlNamedElement;

/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public class AbstractNamedElement implements IWsdlNamedElement {

	private static final long serialVersionUID = 543882515502450373L;
	
	private String name = "";
	
	@Override
	public String getName() {
		return name;
	}

	@Override
	public void setName(String name) {
		if(name != null){
			this.name = name;			
		} else {
			this.name = "";
		}
	}
	
	@Override
	public int hashCode(){
		return name.hashCode();
	}
	
	@Override
	public boolean equals(Object o){
		if(o instanceof IBinding){
			return name.equals(((IBinding) o).getName());
		} else {
			return false;
		}
	}
	
}
