/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.petalsbpm.mapping.client.file.upload;

import com.ebmwebsourcing.petalsbpm.mapping.client.file.upload.service.FileManagementService;
import com.ebmwebsourcing.petalsbpm.mapping.client.file.upload.service.FileManagementServiceAsync;
import com.ebmwebsourcing.petalsbpm.mapping.client.file.upload.service.to.UploadedFiles;
import com.google.gwt.core.client.GWT;
import com.google.gwt.junit.client.GWTTestCase;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;

public class GwtTestFileManagmentService
extends GWTTestCase {
    private FileManagementServiceAsync fileService;
    private int cpt;
    private final int delay = 20000;
    public static final String VALID_URL = "petalslink";

    protected void gwtSetUp() throws Exception {
        super.gwtSetUp();
        this.fileService = (FileManagementServiceAsync)GWT.create(FileManagementService.class);
        this.cpt = 0;
    }

    public void testGetAlreadyUploaded() {
        this.delayTestFinish(20000);
        this.fileService.getAlreadyUploaded((AsyncCallback)new AsyncCallback<UploadedFiles>(){

            public void onFailure(Throwable arg0) {
                arg0.printStackTrace();
                Assert.fail((String)("Should not have failed (this service never throws exceptions in a normal behavior): " + arg0.getMessage()));
            }

            public void onSuccess(UploadedFiles arg0) {
                Assert.assertNotNull((Object)arg0);
                GwtTestFileManagmentService.this.finishTest();
            }
        });
    }

    public void testTestURL() {
        int total = 3;
        this.delayTestFinish(20000);
        String serviceClass = "com.ebmwebsourcing.petalsbpm.mapping.server.file.upload.FakeWSDLRepositoryInquiryService";
        String url = "urlpourrie";
        System.out.println("TEST : testURL with invalid url : " + url);
        this.fileService.testURL("urlpourrie", serviceClass, (AsyncCallback)new AsyncCallback<Boolean>(){

            public void onSuccess(Boolean arg0) {
                Assert.fail((String)("Should have failed : " + arg0));
            }

            public void onFailure(Throwable arg0) {
                Assert.assertNotNull((Object)arg0);
                GwtTestFileManagmentService.this.cpt++;
                if (GwtTestFileManagmentService.this.cpt == 3) {
                    GwtTestFileManagmentService.this.finishTest();
                }
            }
        });
        url = VALID_URL;
        System.out.println("TEST : testURL with valid url : " + url);
        this.fileService.testURL(url, serviceClass, (AsyncCallback)new AsyncCallback<Boolean>(){

            public void onSuccess(Boolean arg0) {
                Assert.assertNotNull((Object)arg0);
                Assert.assertTrue((boolean)arg0);
                GwtTestFileManagmentService.this.fileService.searchFile(null, (AsyncCallback)new AsyncCallback<Map<String, String>>(){

                    public void onFailure(Throwable arg0) {
                        Assert.fail((String)("Should not have failed : " + arg0));
                    }

                    public void onSuccess(Map<String, String> arg0) {
                        Assert.assertNotNull(arg0);
                        Assert.assertEquals((int)1, (int)arg0.size());
                        Assert.assertTrue((boolean)arg0.containsKey("fakeWSDLName"));
                        GwtTestFileManagmentService.this.cpt++;
                        if (GwtTestFileManagmentService.this.cpt == 3) {
                            GwtTestFileManagmentService.this.finishTest();
                        }
                    }
                });
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("fakeWSDLName", "fakeWSDLId");
                GwtTestFileManagmentService.this.fileService.writeFilesFromRepoDescription(map, (AsyncCallback)new AsyncCallback<Void>(){

                    public void onFailure(Throwable arg0) {
                        Assert.fail((String)("Should not have failed : " + arg0));
                    }

                    public void onSuccess(Void arg0) {
                        GwtTestFileManagmentService.this.cpt++;
                        if (GwtTestFileManagmentService.this.cpt == 3) {
                            GwtTestFileManagmentService.this.finishTest();
                        }
                    }
                });
            }

            public void onFailure(Throwable arg0) {
                Assert.fail((String)("Should not have failed : " + arg0));
            }
        });
    }

    public void testUploadFile() {
        this.delayTestFinish(20000);
        String url = "urlpourrie";
        this.fileService.uploadFile(url, "userId", (AsyncCallback)new AsyncCallback<Void>(){

            public void onSuccess(Void arg0) {
                Assert.fail((String)"RPC call should not have successed");
            }

            public void onFailure(Throwable arg0) {
                GwtTestFileManagmentService.this.finishTest();
            }
        });
    }

    public String getModuleName() {
        return "com.ebmwebsourcing.petalsbpm.mapping.BPMNMapping";
    }
}

