/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.petalsbpm.server.plugin.bpmn;

import com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.BPMNMetaDataFormat;
import com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.WSDLProjectInstanceMetaData;
import com.ebmwebsourcing.petalsbpm.server.plugin.bpmn.executable.WSDLLoader;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceFormat;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceMetaData;
import com.ebmwebsourcing.webeditor.impl.domain.exception.ServiceException;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import org.junit.Assert;
import org.junit.Test;

public class WSDLLoaderTest {
    @Test
    public void testCompatibleWSDLLoading() throws URISyntaxException, ServiceException {
        URL url = ClassLoader.getSystemResource("exemple.wsdl");
        File wsdl = new File(url.toURI());
        IProjectInstanceMetaData data = new WSDLLoader().getMetaData(wsdl, (IProjectInstanceFormat)BPMNMetaDataFormat.WSDL1_1);
        Assert.assertNotNull((Object)data);
        Assert.assertTrue((boolean)(data instanceof WSDLProjectInstanceMetaData));
        WSDLProjectInstanceMetaData wsdlData = (WSDLProjectInstanceMetaData)data;
        Assert.assertNotNull((Object)wsdlData.getWsdlImport());
    }

    @Test
    public void testIncompatibleWSDLLoading() throws URISyntaxException {
        URL url = ClassLoader.getSystemResource("incompatibleWSDL.wsdl");
        File wsdl = new File(url.toURI());
        try {
            new WSDLLoader().getMetaData(wsdl, (IProjectInstanceFormat)BPMNMetaDataFormat.WSDL1_1);
        }
        catch (ServiceException e) {
            return;
        }
        Assert.fail((String)"Should have thrown an exception");
    }
}

