/**
 * bpmn-plugins - Geasy BPMN Editor Plugins - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.client.component.bpmn;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.geasytools.diagrameditor.DiagramController;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramView;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.events.IDiagramElementViewUpdateEvent;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.events.IDiagramViewHandler;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.events.IDiagramViewUpdateEvent;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.events.validation.ShowContextualNotificationsEvent;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.validation.DefaultValidationNotificationHandler;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.validation.DiagramValidationException;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.validation.RuleNotificationView;
import com.ebmwebsourcing.geasytools.geasyui.api.selectable.ISelectable;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.INewUIElementEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IRemoveUIElementEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IResizeRequestEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.ISelectedElementsEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IUIPanelHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IUnselectedElementsEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.palette.Palette;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.cloneable.ICloneableProxy;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.detachable.IDetachableProxy;
import com.ebmwebsourcing.geasytools.webeditor.api.components.IComponentDispatcherCommand;
import com.ebmwebsourcing.geasytools.webeditor.api.components.menu.IMenuItem;
import com.ebmwebsourcing.geasytools.webeditor.api.components.menu.IMenuItemAction;
import com.ebmwebsourcing.geasytools.webeditor.api.components.menu.IMenuItemActionType;
import com.ebmwebsourcing.geasytools.webeditor.api.layout.DefaultPlaceHolderPositions;
import com.ebmwebsourcing.geasytools.webeditor.api.plugin.IProjectPlugin;
import com.ebmwebsourcing.geasytools.webeditor.api.project.content.events.ICopyEvent;
import com.ebmwebsourcing.geasytools.webeditor.api.project.content.events.IDeleteEvent;
import com.ebmwebsourcing.geasytools.webeditor.api.project.content.events.IPasteEvent;
import com.ebmwebsourcing.geasytools.webeditor.api.project.content.events.ISelectAllEvent;
import com.ebmwebsourcing.geasytools.webeditor.api.project.content.events.IUserContentHandler;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.component.ComponentDispatcherCommand;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.component.DiagramPanelComponent;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.content.events.ContentUpdateEvent;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.content.events.SelectContentElementsEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.swimlane.PoolEditorModel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.model.builder.CollaborationBuilder;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.diagram.ProcessPanel;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.collaboration.ICollaborationBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.infrastructure.IDefinitionsBean;
import com.ebmwebsourcing.petalsbpm.business.domain.di.api.IBPMNDiagram;
import com.ebmwebsourcing.petalsbpm.business.domain.di.impl.BPMNChoreographyDiagram;
import com.ebmwebsourcing.petalsbpm.business.domain.di.impl.BPMNCollaborationDiagram;
import com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.BPMNProjectInstance;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstance;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceContentElement;
import com.ebmwebsourcing.webeditor.api.domain.project.ProjectValidationException;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.gwtext.client.widgets.Panel;

public class ProcessPanelComponent extends DiagramPanelComponent {
	
	private Panel mainPanel;
	
	private IDiagramView diagramView;
	protected DiagramController diagramController;
	
	private ComponentDispatcherCommand cp1;
	private ComponentDispatcherCommand cp2;
	private ComponentDispatcherCommand cp3;
	protected BPMNProjectInstance projectInstance;

	protected DiagramModelEditorComponent diagramModelEditorComponent;
	
	private IProjectPlugin<?> plugin;
	
	private String title;

	
	public ProcessPanelComponent(IProjectPlugin<?> p, ProcessPanel definitionPanel) {
		super();
		
		this.mainPanel = new Panel();
		this.mainPanel.setClosable(true);
		this.mainPanel.setHeader(false);
		this.plugin = p;
		
		this.diagramView = definitionPanel;
		
		definitionPanel.addUIPanelHandler(new IUIPanelHandler() {
			@Override
			public void onUnSelectUIElement(
					IUnselectedElementsEvent unselectedElementsEvent) {
				plugin.getEventBus().fireEvent(new SelectContentElementsEvent(null));
			}
			
			@Override
			public void onSelectUIElement(ISelectedElementsEvent selectedElementsEvent) {
				ArrayList<ISelectable> selectables = new ArrayList<ISelectable>(selectedElementsEvent.getSelectedElements().values());
				ArrayList<IProjectInstanceContentElement> bpmnelements = new ArrayList<IProjectInstanceContentElement>();
				for(ISelectable s:selectables){
					if (s instanceof IProjectInstanceContentElement){
						bpmnelements.add((IProjectInstanceContentElement) s);
					}
				}
				plugin.getEventBus().fireEvent(new SelectContentElementsEvent(bpmnelements));
			}
			
			@Override
			public void onResizeRequest(IResizeRequestEvent event) {}
			
			@Override
			public void onRemoveUIElement(IRemoveUIElementEvent removeElementEvent) {}
			
			@Override
			public void onNewUIElement(INewUIElementEvent newElementEvent) {}
		});
		
		this.diagramModelEditorComponent = new DiagramModelEditorComponent();

		this.diagramView.addHandler(new IDiagramViewHandler() {
			@Override
			public void onUpdate(IDiagramViewUpdateEvent event) {
				plugin.getEventBus().fireEvent(new ContentUpdateEvent(ProcessPanelComponent.this, null));
			}
			
			@Override
			public void onElementUpdate(IDiagramElementViewUpdateEvent event) {
				plugin.getEventBus().fireEvent(new ContentUpdateEvent(ProcessPanelComponent.this, (IProjectInstanceContentElement) event.getElement()));
			}
		});
		
		
		PaletteComponent paletteComponent = new PaletteComponent((Palette) diagramView.getPalette());
		paletteComponent.setTitle("BPMN 2.0 Palette");
		

		diagramModelEditorComponent.setTitle("Properties");
		this.cp1 = new ComponentDispatcherCommand(diagramModelEditorComponent, DefaultPlaceHolderPositions.SOUTH);
		this.cp2 = new ComponentDispatcherCommand(paletteComponent, DefaultPlaceHolderPositions.WEST);
		
//		TestComponent testComponent = new TestComponent();
//		this.cp3 = new ComponentDispatcherCommand(testComponent, DefaultPlaceHolderPositions.WEST);
		
		definitionPanel.getElement().setAttribute("style", "float:left;position:relative;width:100%;height:100%;overflow:auto;");
		this.mainPanel.add(definitionPanel);

		initWidget(mainPanel);
	}

	
	@Override
	public String getId() {
		return this.getElement().getId();
	}

	
	@Override
	public IDiagramView getDiagramView() {
		return diagramView;
	}

	
	@Override
	public List<IComponentDispatcherCommand> getAssociatedComponentsDispatcherCommands() {
		ArrayList<IComponentDispatcherCommand> result = new ArrayList<IComponentDispatcherCommand>();
	
		result.add(cp1);
		result.add(cp2);
		result.add(cp3);
		
		return result;
	}


	@Override
	public void loadProjectInstance(IProjectInstance projectInstance) {

		BPMNProjectInstance bpmnprojectInstance = (BPMNProjectInstance) projectInstance;
		
		initializeDiagramController(bpmnprojectInstance);
		
		final DefaultValidationNotificationHandler vnh = new DefaultValidationNotificationHandler();
		
		//Validation notifier
		RuleNotificationView ruleNotificationView = new RuleNotificationView(diagramView, diagramController);
		diagramController.setNotificationView(ruleNotificationView);
		

		
		ValidationComponent component = new ValidationComponent(ruleNotificationView);
		this.cp3 = new ComponentDispatcherCommand(component, DefaultPlaceHolderPositions.SOUTH);
		
		this.diagramView.addClickHandler(new ClickHandler() {
			
			@Override
			public void onClick(ClickEvent event) {
				
				vnh.hideAllNotifications();
				
			}
		});
		
		diagramController.addValidationHandler(vnh);
		diagramController.addRuleNotificationHandler(vnh);
		
		//((CommonEditorModel)diagramView.getEditorModel()).setName(bpmnprojectInstance.getName());
		
		//TODO move this elsewhere
		IBPMNDiagram diagramToload = null;
		if(bpmnprojectInstance.getBpmndiagram() instanceof BPMNCollaborationDiagram) {
			diagramToload = GWT.create(BPMNCollaborationDiagram.class);
			((ICloneableProxy<BPMNCollaborationDiagram>)diagramToload).copy((BPMNCollaborationDiagram) bpmnprojectInstance.getBpmndiagram());
		}
		else if(bpmnprojectInstance.getBpmndiagram() instanceof BPMNChoreographyDiagram) {
			diagramToload = GWT.create(BPMNChoreographyDiagram.class);
			((ICloneableProxy<BPMNChoreographyDiagram>)diagramToload).copy((BPMNChoreographyDiagram) bpmnprojectInstance.getBpmndiagram());
		}
		bpmnprojectInstance.setBpmndiagram(diagramToload);
		
		if (bpmnprojectInstance.getBpmndiagram()!=null) this.diagramController.loadDiagram(diagramToload, false);
		
		this.projectInstance = bpmnprojectInstance;
	}

	
	protected void initializeDiagramController(IProjectInstance projectInstance){
		BPMNProjectInstance bpmnprojectInstance = (BPMNProjectInstance) projectInstance;
		this.diagramController = new DiagramController(diagramView,new BPMNCollaborationDiagram(),diagramModelEditorComponent.getEditorView(),bpmnprojectInstance.getDefinitions());
		diagramController.setSyntaxModelBuilder(new CollaborationBuilder(diagramView.getDiagram().getRootElement(),(PoolEditorModel) diagramView.getEditorModel()));
	}

	
	@Override
	public void disableMenuItemsByType(IMenuItemActionType type) {}


	@Override
	public void enableMenuItemsByType(IMenuItemActionType type) {}


	@Override
	public List<IMenuItem> getMenuItems() {
		return null;
	}

	@Override
	public void onActionRequest(IMenuItemAction action) {}


	@Override
	public IProjectInstance getProjectInstance() {
		IDefinitionsBean defs = (IDefinitionsBean) diagramController.getMainModelElement();
		ICollaborationBean collaborationBean = (ICollaborationBean) diagramController.getDiagramSyntaxModel();
		defs.addCollaboration(collaborationBean);
		projectInstance.setDefinitions(defs);
		//TODO: find a way to detach proxy
		
		//TODO get the binded model of the bpmndiagram used by the diagramcontroller
		//projectInstance.setBpmndiagram((IBPMNDiagram) diagramController.getDiagramInterchangeModel(true));
		projectInstance.setBpmndiagram((IBPMNDiagram) ((IDetachableProxy<?>)diagramController.getDiagramInterchangeModel(true)).getDetachedModel());

		return projectInstance;
	}

	
	@Override
	public void setTitle(String title) {
		mainPanel.setTitle(title);
		this.title = title;
	}
	
	
	@Override
	public String getTitle() {
		return this.title;
	}
	
	
	@Override
	public IUserContentHandler getUserContentHandler() {
		return new IUserContentHandler() {
			@Override
			public void onSelectAll(ISelectAllEvent event) {}
			
			@Override
			public void onPaste(IPasteEvent event) {}
			
			@Override
			public void onDelete(IDeleteEvent event) {
				diagramController.removeSelectedElements();
			}
			
			@Override
			public void onCopy(ICopyEvent event) {}
		};
	}


	@Override
	public void validate() throws ProjectValidationException {
		try {
			diagramController.validate();
		} catch (DiagramValidationException e) {
			throw new ProjectValidationException(e.getMessage());
		}finally{
			diagramController.fireEvent(new ShowContextualNotificationsEvent());
		}
	}

}
