/**
 * definitions-editor - BPMN Definitions Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.definitionseditor.definitions;

import com.ebmwebsourcing.petalsbpm.definitionseditor.common.events.CommonHandler;
import com.ebmwebsourcing.petalsbpm.definitionseditor.common.events.PropertyUpdateEvent;
import com.google.gwt.user.client.ui.Composite;
import com.gwtext.client.widgets.form.FormPanel;
import com.gwtext.client.widgets.form.TextField;

public class DefinitionsPropertiesPanel extends Composite {

	private FormPanel mainPanel;
	private TextField name;
	private TextField tns;

	public DefinitionsPropertiesPanel(String title) {
		this.mainPanel = new FormPanel();
		this.mainPanel.setTitle(title);
		this.mainPanel.setFrame(true);

		mainPanel.setHeader(false);
		mainPanel.setBorder(false);

		mainPanel.setMargins(10);

		this.name = new TextField("Name", "name", 230);
		name.setAllowBlank(false);
		name.setTitle("The name of the definition");

		mainPanel.add(name);

		this.tns = new TextField("Target Namespace", "tns", 230);
		mainPanel.add(tns);

		mainPanel.setVisible(false);

		this.initWidget(mainPanel);
	}

	public TextField getName() {
		return name;
	}

	public TextField getTns() {
		return tns;
	}

	@Override
	protected void onAttach() {

	}

	@Override
	protected void onLoad() {
		mainPanel.doLayout();
		mainPanel.setVisible(true);
	}

	public void addHandler(CommonHandler handler) {
		addHandler(handler, PropertyUpdateEvent.TYPE);
	}

}
