/**
 * definitions-editor - BPMN Definitions Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.definitionseditor.eventdefinition.conditional;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.AbstractEditableGrid;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.event.definition.IConditionalEventDefinitionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.event.definition.ConditionalEventDefinitionBean;
import com.ebmwebsourcing.petalsbpm.definitionseditor.Constants.ConditionalEventDefinition;
import com.google.gwt.user.client.DOM;
import com.gwtext.client.data.FieldDef;
import com.gwtext.client.data.Record;
import com.gwtext.client.data.StringFieldDef;
import com.gwtext.client.widgets.form.TextField;
import com.gwtext.client.widgets.grid.BaseColumnConfig;
import com.gwtext.client.widgets.grid.ColumnConfig;
import com.gwtext.client.widgets.grid.EditorGridPanel;
import com.gwtext.client.widgets.grid.GridEditor;

public class ConditionalEventDefinitionPanel extends AbstractEditableGrid<IConditionalEventDefinitionBean>{

	public ConditionalEventDefinitionPanel() {
		super();

	}
	
	@Override
	protected void buildGrid() {
		super.buildGrid();
		gridPanel.getView().setForceFit(true);
	}
	
	
	@Override
	protected void bind(Record record, IConditionalEventDefinitionBean value) {
		value.setCondition(record.getAsString(ConditionalEventDefinition.expression.toString()));
	}

	@Override
	protected String getAddText() {
		return "Add Conditional Event Definition";
	}

	@Override
	protected IConditionalEventDefinitionBean getNewDefaultRecord() {
		return new ConditionalEventDefinitionBean(DOM.createUniqueId());
	}

	@Override
	protected String getRemoveText() {
		return "Remove Conditional Event Definition";
	}

	@Override
	protected Object[] convertDataToObject(IConditionalEventDefinitionBean data) {
		
		Object[] object  = new Object[2];
		
		object[0] = data.getId();
		object[1] = data.getCondition();
		
		return object;
	}

	@Override
	protected List<BaseColumnConfig> getColumnsConfig() {
		
		ArrayList<BaseColumnConfig> cc 		= new ArrayList<BaseColumnConfig>();
		
		ColumnConfig idColumn = new ColumnConfig(ConditionalEventDefinition.id.getLabel(), ConditionalEventDefinition.id.toString());
		
		ColumnConfig expressionColumn = new ColumnConfig(ConditionalEventDefinition.expression.getLabel(), ConditionalEventDefinition.expression.toString());
		expressionColumn.setEditor(new GridEditor(new TextField()));
		
		cc.add(idColumn);
		cc.add(expressionColumn);
		
		return cc;
	}

	@Override
	protected FieldDef[] getFieldDef() {
		return new FieldDef[]{
				new StringFieldDef(ConditionalEventDefinition.id.toString()),
				new StringFieldDef(ConditionalEventDefinition.expression.toString()),
		};
	}

	@Override
	protected boolean isValid(IConditionalEventDefinitionBean data) {
		
		if (data.getId()!=null && data.getCondition()!=null && data.getCondition().equals("")==false){
			return true;
		}
		
		return false;
	}
	
	@Override
	protected EditorGridPanel getGridPanel() {
		return super.getGridPanel();
	}
	
}
